package com.hummer.im.service;

import android.support.annotation.NonNull;

import com.hummer.im.HMR;
import com.hummer.im.model.id.User;

import java.util.List;

/**
 * 黑名单关系服务接口
 */
@SuppressWarnings("unused")
public interface BlacklistService {
    /**
     * 获取黑名单列表
     */
    void listBlacklist(HMR.CompletionArg<List<User>> completion);

    /**
     * 用于判定指定用户是否在黑名单
     *
     * @param user 需要判定的用户
     * @param completion 该操作的异步回调
     */
    void isBlocked(@NonNull User user, HMR.CompletionArg<Boolean> completion);

    /**
     * 将同伴加入黑名单
     *
     * @param user     被加入黑名单的同伴
     * @param completion 该操作的异步回调
     */
    void block(@NonNull User user, @NonNull HMR.Completion completion);

    /**
     * 将指定同伴从黑名单中移除
     *
     * @param user     欲移除的同伴
     * @param completion 该操作的异步回调
     */
    void unblock(@NonNull User user, @NonNull HMR.Completion completion);

    /**
     * 添加黑名单回调监听器
     *
     * @param listener 监听器对象
     */
    void addListener(@NonNull BlacklistListener listener);

    /**
     * 移除黑名单回调监听器
     *
     * @param listener 监听器对象
     */
    void removeListener(@NonNull BlacklistListener listener);

    interface BlacklistListener {
        /**
         * 当拉黑了一个用户时，会收到该回调，由本用户发起
         * @param user 被拉黑的用户
         */
        void onBlockUser(@NonNull User user);

        /**
         * 取消拉黑一个用户的回调
         * @param user 被取消拉黑的用户
         */
        void onUnblockUser(@NonNull User user);

        /**
         * 被其他用户拉黑时的回调
         * @param user 拉黑我的用户
         */
        void onBlockedByUser(@NonNull User user);

        /**
         * 被其他用户取消拉黑时的回调
         * @param user 取消拉黑我的用户
         */
        void onUnblockedByUser(@NonNull User user);

        /**
         * 本地用户的黑名单列表发生变化时，会产生该回调
         * @param blockedUsers 我的黑名单列表
         */
        void onUpdateBlacklist(@NonNull List<User> blockedUsers);
    }

}
