package com.hummer.im.model.signal;

import java.util.Map;

public class Message {
    private String type;
    private byte[] data;
    private long serverAcceptedTs;
    private Map<String, String> appExtras;

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setServerAcceptedTs(long serverAcceptedTs) {
        this.serverAcceptedTs = serverAcceptedTs;
    }

    public void setAppExtras(Map<String, String> appExtras) {
        this.appExtras = appExtras;
    }

    public String getType() {
        return type;
    }

    public byte[] getData() {
        return data;
    }

    public long getServerAcceptedTs() {
        return serverAcceptedTs;
    }

    public Map<String, String> getAppExtras() {
        return appExtras;
    }

    public Message(final String type, final byte[] data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public String toString() {
        return "Message{" +
                "type='" + type + '\'' +
                ", serverAcceptedTs=" + serverAcceptedTs +
                '}';
    }
}
