package com.hummer.im.model.id;

public class AppSession extends Identifiable {

    private final long id;
    private final String type;

    public AppSession(String type, long id) {
        this.type = type;
        this.id = id;
    }

    public String getType() {
        return type;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public String toString() {
        return "AppSession{" + id + ", " + type + '}';
    }

    @Override
    public int hashCode() {
        return Long.valueOf(id).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof AppSession)) {
            return false;
        }

        AppSession appSession = (AppSession) o;
        return (id == appSession.id && type.equals(appSession.type));
    }
}
