package com.hummer.im.model.chat.store;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.Identifiable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 【本地/服务器】获取会话对应消息时的条件集
 */
public final class FetchingClauses {

    /**
     * 最大消息数量。服务器目前对该值进行了限制，取值范围为: [1, 100]。如果使用null值，则默认使用最大值(100)。
     */
    private Integer limit;

    /**
     * 消息锚点：查询beforeMessage消息之前的消息
     */
    private Message beforeMessage;

    /**
     * 时间锚点（毫秒）：查询beforeTime时间之前的消息
     */
    private Long beforeTimestamp;

    /**
     * 消息所属的关系目标：不设置表示查询当前会话下所有目标消息
     */
    private Set<Identifiable> senders;

    /**
     * 消息类型：不设置表示查询所有消息类型的消息
     */
    private Set<Class<Content>> messageTypes;

    public FetchingClauses setLimit(@NonNull Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    public Integer getLimit() {
        return limit;
    }

    public FetchingClauses setBeforeMessage(@NonNull Message beforeMessage) {
        this.beforeMessage = beforeMessage;
        return this;
    }

    @Nullable
    public Message getBeforeMessage() {
        return beforeMessage;
    }

    public FetchingClauses setBeforeTimestamp(@NonNull Long beforeTimestamp) {
        this.beforeTimestamp = beforeTimestamp;
        return this;
    }

    @Nullable
    public Long getBeforeTimestamp() {
        return beforeTimestamp;
    }

    public FetchingClauses setSenders(Set<Identifiable> senders) {
        this.senders = senders;
        return this;
    }

    @Nullable
    public Set<Identifiable> getSenders() {
        return senders;
    }

    public FetchingClauses setMessageTypes(Set<Class<Content>> messageTypes) {
        this.messageTypes = messageTypes;
        return this;
    }

    @Nullable
    public Set<Class<Content>> getMessageTypes() {
        return messageTypes;
    }

    @Override
    public String toString() {
        String string = "FetchingClauses{";

        if (limit == null && beforeMessage == null) {
            string += "All";
        } else {
            List<String> parts = new ArrayList<>();

            if (beforeMessage != null) {
                parts.add("before: " + beforeMessage);
            }

            if (limit != null) {
                parts.add("limit: " + limit);
            }

            if (beforeTimestamp != null) {
                parts.add("beforeTime: " + beforeTimestamp);
            }

            if (senders != null) {
                parts.add("senders.size: " + senders.size());
            }

            if (messageTypes != null) {
                parts.add("messageTypes.size: " + messageTypes.size());
            }

            string += TextUtils.join(", ", parts);
        }

        string += "}";

        return string;
    }
}
