package com.hummer.im.model.chat.contents;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Im;
import com.hummer.im.model.chat.Content;

/**
 * Hummer内置的文本消息内容类型
 */
public final class Text extends Content {

    /**
     * 构造一个文本消息
     * @param text 消息的文本内容
     */
    public Text(String text) {
        this.text = text;
    }

    /**
     * 获取消息的文本
     */
    public String getText() {
        return text;
    }

    @Override
    public String toString() {
        return "Text{" + getText() + "}";
    }

    /**
     * 注册文本消息的编码、解码器
     */
    public static void registerCodecs() {
        registerCodec(new Codec() {
            @Override
            public int type() {
                return Im.MsgType.kText_VALUE;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Text.class;
            }

            @Override
            public Content makeChatContent(byte[] data) throws Throwable {
                Im.TextMsg msgProto = Im.TextMsg.newBuilder().mergeFrom(data).build();
                return new Text(msgProto.getText());
            }

            @Override
            public Content makeChatContent(String data) {
                return new Text(data);
            }

            @Override
            public byte[] makePBBytes(Content content) {
                Text textChat = (Text) content;

                Im.TextMsg textMsg = Im.TextMsg.newBuilder()
                        .setText(textChat.getText())
                        .build();

                return textMsg.toByteArray();
            }

            @Override
            public String makeDBString(Content content) {
                if (!(content instanceof Text)) {
                    Log.e("Text", Trace.once().method("makeDBString")
                            .info("content", content));
                    return null;
                }
                return ((Text) content).getText();
            }

            @Override
            public String toString() {
                return "TextCodec";
            }
        });
    }

    private String text;
}
