package com.hummer.im.model.chat;

import com.hummer.im._internals.shared.StringChain;

/**
 * 聊天消息携带的推送消息内容
 */
@SuppressWarnings({"WeakerAccess", "unused"})
public class PushContent {

    /**
     * 推送消息的标题内容
     */
    public String getTitle() {
        return title;
    }

    /**
     * 推送消息的消息内容
     */
    public String getContent() {
        return content;
    }

    /**
     * payload 是推送消息的业务携带数据
     */
    public byte[] getPayload() {
        return payload;
    }

    /**
     * 通知栏中展示的图标链接
     */
    public String getIconUrl() {
        return iconUrl;
    }

    /**
     * 构造消息推送所需的Content实例，用于帮助CIM后台确定消息推送的具体内容。
     *
     * @param title   消息推送的标题内容
     * @param content 消息推送的消息内容
     * @param payload 消息推送所携带的业务自定义数据
     * @param iconUrl 消息推送弹通知栏时所显示的图标URL字符串
     */
    public PushContent(String title, String content, byte[] payload, String iconUrl) {
        this.title   = title;
        this.content = content;
        this.payload = payload;
        this.iconUrl = iconUrl;
    }

    @Override
    public String toString() {
        return "PushContent{" + new StringChain()
                .add("title",   title)
                .add("cont",    content)
                .add("iconUrl", iconUrl)
                + "}";
    }

    private final String title;
    private final String content;
    private final byte[] payload;
    private final String iconUrl;
}
