package com.hummer.im._internals.yyp.packet;

public class Sender extends Header {

    private Pack pack = new Pack();
    private int bodySize;

    public Sender(Marshallable m) {
        m.marshall(pack);
        bodySize = pack.size();
    }

    public void endPack() {
        pack.getBuffer().position(bodySize());
        pack.getBuffer().flip();

    }

    public Pack getPack() {
        return pack;
    }

    public int bodySize() {
        return bodySize;
    }

    public byte[] getBytes() {
        return getPack().toBytes();
    }
}
