package com.hummer.im._internals.user;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.AsciiTable;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;

import java.util.Set;

public final class UserServiceImpl implements UserService, ServiceProvider.Service {

    @Override
    public void initService() {
    }

    @Override
    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public void openService(@NonNull RichCompletion completion) {
        showOpenMessage();

        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void closeService() {
        UserServiceImpl.this.tags = null;
    }

    @Override
    public void setTags(@Nullable Set<String> tags, @Nullable final RichCompletion completion) {
        HMR.getService(Channel.class).run(new RPCSetUserTags(tags, completion));
    }

    private static void showOpenMessage() {
        HMRContext.Region env = HMRContext.region;
        User me = HMR.getMe();

        AsciiTable.log(40, "Open", new String[][]{
                {"area", env.area},
                {"type", env.type},
                {"name", env.name},
                {"uid", String.valueOf(me.getId())},
        });
    }

    private Set<String> tags;
}
