package com.hummer.im._internals.shared.statis;

import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.HiidoReporter;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by WuWangchun on 2017/7/3.
 */

public class MetricsWorker {
    public static final String ACT = "mmetric";
    private static final String TAG = "MetricsWorker";

    private int maxCount;
    private IStatisHttpUtil mMetircs;
    private IStatisHttpUtil mHiido;

    private MetricsPkg pkg;
    private AtomicInteger count = new AtomicInteger(0);
    private String appKey;

    private boolean mTimerStart = false;

    public MetricsWorker(String appKey,
                         IStatisHttpUtil metrics,
                         IStatisHttpUtil hiido) {
        this.maxCount = 10;
        this.mMetircs = metrics;
        this.mHiido = hiido;
        this.appKey = appKey;

        this.pkg = new MetricsPkg(maxCount);
        this.mTimerStart = false;
    }

    private void changePkgMaxCount(boolean succ) {
        if (succ) {
            maxCount = maxCount + 5;
        } else {
            maxCount = maxCount - 5;
        }
        if (maxCount > 100) maxCount = 100;
        if (maxCount < 5) maxCount = 5;

        Log.i(HiidoReporter.TAG, String.format(Locale.US,
                "report Metrics next pkg piece count: %d. ", maxCount));
    }

    private void checkPkgWithTimer() {
        if (this.count.get() > 0 && (!mTimerStart)) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US,
                    "post timer to report Metrics pkg count: %d", this.count.get()));
            mTimerStart = true;
            HMRContext.work.asyncAfter("MEtricsWorker::checkPkgWithTimer", 2 * 60 * 1000, new Runnable() {
                @Override
                public void run() {
                    onTimer();
                    mTimerStart = false;
                }
            });
        }
    }

    private void onTimer() {
        if (this.count.get() > 0) {
            try {
                Log.i(HiidoReporter.TAG, String.format(Locale.US,
                        "report Metrics onTimer piece count: %d. ", count.get()));
                MetricsPkg p = this.pkg;
                this.pkg = new MetricsPkg(maxCount);
                count.set(0);
                sendPkg(p);
            } catch (Throwable e) {
                Log.e(TAG, Trace.once().method("onTimer").info("error", e.getMessage()));
            }
        }
    }

    private void sendPkg(MetricsPkg pkg) {
        try {
            List<JSONObject> obj = pkg.toJson();
            for (JSONObject one : obj) {
                String str = toContent(one);
                if (str != null) {
                    sendHttp(str);
                }
            }
        } catch (Throwable e) {
            Log.e(TAG, Trace.once().method("sendPkg").info("error", e.getMessage()));
        }
    }

    private void sendHttp(String content) {
        try {
            //加上客户端发送时间
            content = String.format(Locale.US, "%s&hd_stime=%d", content, Util.wallTimeMillis());

            boolean suc = mMetircs.sendSync(content);
            changePkgMaxCount(suc);

            Log.i(HiidoReporter.TAG, String.format(Locale.US,
                    "report Metrics %B to send command %s. ", suc, content));
        } catch (Throwable e) {
            Log.e(TAG, Trace.once().method("sendHttp").info("error", e.getMessage()));
        }
    }

    private String toContent(JSONObject param) {
        /**
         *
         appkey : hiido移动统计的appkey,能填即填,
         ver    : app版本,
         sdkver : sdk版本,
         sys    : 操作系统平台0=IOS/1=WP/2=Android/3=Mac
         osver  : ios11,
         model  : 手机型号,
         net    : 网络类型,
         ntm    : 网络运营商，能填即填,
         hdid   : 海度hdid,能填即填,
         imei   : imei,
         mac    : mac地址,
         clienttime: 客户端时间,
         reqdata    : [
         { scode : 101, uri:xxxx,reqtime:80,ret:0, rtime:生成记录的毫秒时间戳(14xxxxxxxxxxx) },
         { scode : 101, uri:xxxx%7cyyyy,reqtime:80,ret:0, rtime:生成记录的毫秒时间戳}
         ],
         counterdata :[
         { scode : 101, uri:kkkk, counterName : xxxfff, value:999, invokecount:20 }
         ]
         */

        try {
            StatisContent content = new StatisContent();

            final String timeStamp = String.valueOf(Util.wallTimeSec());
            content.put(StatisContent.ACT, ACT);
            content.put(StatisContent.TIME, timeStamp);
            content.put(StatisContent.KEY, calKey(ACT, timeStamp));
            content.put("appkey", appKey);
            long l;
            try {
                l = param.getLong("clienttime");
            } catch (Throwable e) {
                l = System.currentTimeMillis();
            }
            content.put("clienttime", String.valueOf(l / 1000));

            JSONArray req = null;
            if (param.has("reqdata")) {
                req = param.getJSONArray("reqdata");
            }
            JSONArray counterdata = null;
            if (param.has("counterdata")) {
                counterdata = param.getJSONArray("counterdata");
            }

            if (req != null) {
                content.put("reqdata", notNull(req.toString()));
            }
            if (counterdata != null) {
                content.put("counterdata", notNull(counterdata.toString()));
            }

            return content.toString();
        } catch (Throwable e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        }
        return null;
    }

    private String notNull(String str) {
        return str == null ? "" : str;
    }

    /**
     * This is protocol magic, don't ever change it except when protocol
     * changes.
     */
    private static final String KEY_MAGIC = "HiidoYYSystem";

    private String calKey(String act, String time) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(act);
        sBuilder.append(time);
        sBuilder.append(KEY_MAGIC);

        String raw = sBuilder.toString();
        sBuilder.setLength(0);

        try {
            return Util.encryptMD5(raw).toLowerCase(Locale.getDefault());
        } catch (Throwable e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        }
        return null;
    }

    public MetricsPkg cutPiece() {
        MetricsPkg p = null;
        synchronized (this) {
            int c = count.get();
            if (c > maxCount) {
                p = this.pkg;
                this.pkg = new MetricsPkg(maxCount);
                count.set(0);
            }
        }
        return p;
    }

    public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
        MetricsResult result = new MetricsResult(scode, uri, timeConsumption, code);
        pkg.addMetricsResult(result);
        int c = count.incrementAndGet();
        if (c > maxCount) {
            MetricsPkg pkg = cutPiece();
            if (pkg != null) {
                sendPkg(pkg);
            }
        }
        checkPkgWithTimer();
    }

    public void reportCount(int scode, String uri, String countName, long count) {
        reportCount(scode, uri, countName, count, 1);
    }

    public void reportCount(int scode, String uri, String countName, long count, int times) {
        MetricsCount c = new MetricsCount(scode, uri, countName);
        c.count(count, times);
        if (pkg.addCounter(c)) {
            int add = this.count.incrementAndGet();
            if (add > maxCount) {
                MetricsPkg pkg = cutPiece();
                if (pkg != null) {
                    sendPkg(pkg);
                }
            }
        }
        checkPkgWithTimer();
    }

    public void reportReturnCodeTemporary(int scode, String uri, long timeConsumption, String code) {
        Log.i(HiidoReporter.TAG, String.format(Locale.US,
                "report return code uri: %s, code: %s", uri, code));
        MetricsPkg pkg = new MetricsPkg(0);

        MetricsResult result = new MetricsResult(scode, uri, timeConsumption, code);
        pkg.addMetricsResult(result);
        sendPkg(pkg);
    }

    public void reportHiidoTemporary(String act, Map<String, Integer> intFields,
                                     Map<String, Long> longFields, Map<String, String> stringFields) {
        StatisContent content = new StatisContent();
        for (Map.Entry<String, Integer> entry : intFields.entrySet()) {
//            Log.i(HiidoReporter.TAG,String.format(Locale.US,"report act=%s,key=%s,int value=%d",
//                    act, entry.getKey(), entry.getValue()));
            content.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Long> entry : longFields.entrySet()) {
//            Log.i(HiidoReporter.TAG,String.format(Locale.US,"report act=%s,key=%s,long value=%d",
//                    act, entry.getKey(), entry.getValue()));
            content.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : stringFields.entrySet()) {
//            Log.i(HiidoReporter.TAG,String.format(Locale.US,"report act=%s,key=%s,string value=%s",
//                    act, entry.getKey(), entry.getValue()));
            content.put(entry.getKey(), entry.getValue());
        }
        content.put("appkey", appKey);
        final String timeStamp = String.valueOf(Util.wallTimeSec());
        content.put(StatisContent.ACT, act);
        content.put(StatisContent.TIME, timeStamp);
        //3.0.5版本开始不再验证,3.0.6还原，必须要加上，不然会有不可预知的影响
        content.put(StatisContent.KEY, calKey(act, timeStamp));

        mHiido.sendSync(content.getContent());
    }
}
