package com.hummer.im._internals.shared;

import com.hummer.im._internals.log.Log;

import java.util.Locale;

public final class AsciiTable {

    public static void log(int width, String header, String[][] fields) {
        String paddingLine = repeatedString((width - 4 - header.length()) / 2, "━");
        String headerLine = String.format(Locale.US, "┏%s %s %s┓", paddingLine, header, paddingLine);
        Log.i(null, headerLine);

        int maxFieldLength = 0;
        for (String[] field : fields) {
            maxFieldLength = Math.max(maxFieldLength, field[0].length());
        }

        String lineFormat = String.format(Locale.US, "┃ %%-%ds : %%-%ds ┃",
                maxFieldLength, width - 7 - maxFieldLength);

        for (String[] field : fields) {
            Log.i(null, String.format(Locale.US, lineFormat, field[0], field[1]));
        }

        Log.i(null, String.format(Locale.US, "┗%s┛", repeatedString(width - 2, "━")));
    }

    @SuppressWarnings("SameParameterValue")
    private static String repeatedString(int count, String str) {
        StringBuilder sb = new StringBuilder();
        while (count > 0) {
            sb.append(str);
            count -= 1;
        }
        return sb.toString();
    }
}
