package com.hummer.im._internals.services.user;

import android.support.annotation.Nullable;

import com.hummer.im.model.completion.RichCompletion;

import java.util.Set;

/**
 * 用户信息管理服务，目前仅提供了用户标签管理
 */
@SuppressWarnings("unused")
public interface UserService {

    /**
     * 设置用户标签集
     *
     * <br> 用户标签会造成下述影响：
     * <br> 1. Push的发送会根据用户标签进行匹配发送
     * <br> 2. 共享消息在拉取时，会根据标签进行过滤
     *
     * @param tags       标签集数据
     * @param completion 异步操作回调
     */
    void setTags(@Nullable Set<String> tags, @Nullable RichCompletion completion);
}
