package com.hummer.im._internals.services.upload;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.upload.YYaliOSS.AliOSS;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.service.UploadService;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UploadServiceImp implements UploadService, ServiceProvider.Service {

    private static final String TAG = "UploadServiceImp";
    private static Uploader mUploader;
    private Map<String, UploadTask> tasks = new HashMap<>();

    @Override
    public Class[] staticDependencies() {
        return null;
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public void initService() {
    }

    @Override
    public void openService(@NonNull RichCompletion completion) {
        registerUploader(new AliOSS());
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void closeService() {
    }

    @Override
    public void registerUploader(@NonNull Uploader uploader) {
        mUploader = uploader;
    }

    public Uploader getUploader() {
        return mUploader;
    }

    @Override
    public void uploadFile(@NonNull final String filePath,
                           @NonNull final Uploader.UploadCallback<String> clientCallback) {
        HMRContext.work.async("UploadServiceImp::uploadFile", new Runnable() {
            @Override
            public void run() {
                UploadTask task = tasks.get(filePath);

                if (task == null) {
                    Log.i(TAG, Trace.once().method("uploadFile").msg("New task")
                            .info("path", filePath));

                    task = new UploadTask(filePath);
                    tasks.put(filePath, task);
                    task.callbacks.add(clientCallback);

                    final UploadTask finalTask = task;

                    mUploader.uploadFile(filePath, new Uploader.UploadCallback<String>() {
                        @Override
                        public void onProgress(float value) {
                            finalTask.notifyProgress(value);
                        }

                        @Override
                        public void onSuccess(String destUrl) {
                            finalTask.notifySuccess(destUrl);
                            tasks.remove(filePath);
                        }

                        @Override
                        public void onFailure(Error err) {
                            finalTask.notifyFailed(err);
                            tasks.remove(filePath);
                        }
                    });
                } else {
                    Log.i(TAG, Trace.once().method("uploadFile").msg("Existed task")
                            .info("path", filePath));

                    // 此任务已存在，把callback添加到对应的观察者列表就行
                    task.callbacks.add(clientCallback);
                }
            }
        });
    }

    @Override
    public void cancelUploadFile(String filePath) {
        UploadTask task = tasks.get(filePath);
        if (task == null) {
            return;
        }

        mUploader.cancelUploadFile(filePath);
    }

    private static final class UploadTask {

        UploadTask(String filePath) {
            this.path = filePath;
        }

        void notifyProgress(float value) {
            for (Uploader.UploadCallback<String> cb : callbacks) {
                cb.onProgress(value);
            }
        }

        void notifySuccess(String dstPath) {
            for (Uploader.UploadCallback<String> cb : callbacks) {
                cb.onSuccess(dstPath);
            }
        }

        void notifyFailed(Error error) {
            for (Uploader.UploadCallback cb : callbacks) {
                cb.onFailure(error);
            }
        }

        String path;
        Set<Uploader.UploadCallback<String>> callbacks = new HashSet<>();
    }
}
