package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im._internals.services.mq.RPCPullingResponse;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

public class RPCPullSharedMessages extends IMRPC<Pull.PullGroupSysMsgRequest,
        Pull.PullGroupSysMsgRequest.Builder, Pull.PullGroupSysMsgResponse> {

    public static final String TAG = "RPCPullSharedMessages";
    private final Trace.Flow flow = new Trace.Flow();
    private final long groupId;
    private final String topic;
    private final boolean isInitialDrain;
    private final long seqId;
    private final int count;
    private final RichCompletionArg<RPCPullingResponse> completion;

    public RPCPullSharedMessages(long groupId,
                                 String topic,
                                 long startSeqId,
                                 int count,
                                 boolean isInitialDrain,
                                 RichCompletionArg<RPCPullingResponse> completion) {
        this.isInitialDrain = isInitialDrain;
        this.groupId = groupId;
        this.topic = topic;
        this.seqId = startSeqId;
        this.count = count;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "PullGroupSysMsg";
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.PullGroupSysMsgRequest.Builder builder) throws Throwable {
        builder.setGroupId(groupId)
                .addAllUserTags(HMR.getTags())
                .setTopic(topic)
                .setExclusiveStartSeqId(seqId)
                .setLimit(count)
                .setStatisDeliveryDelay(!isInitialDrain)

                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.PullGroupSysMsgResponse res) throws Throwable {
        // 进行明确的语义转换，0实际上是表示没有seqId
        final Long maxSeqId = res.getMaxSeqId() > 0 ? res.getMaxSeqId() : null;
        CompletionUtils.dispatchSuccess(completion,
                new RPCPullingResponse(res.getMsgsList(), res.getHasMore(), maxSeqId));
    }

    @Override
    public void handleHummerError(@Nullable Pull.PullGroupSysMsgResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.PullGroupSysMsgResponse res) {
        return new StringChain().acceptNullElements()
                .add("code", res.getCode())
                .add("desc", res.getMsg())
                .toString();
    }
}

