package com.hummer.im._internals.mq;


import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.completion.CompletionUtils;

public class RPCFetchSharedMaxSeqId extends IMRPC<Pull.GetGrpSysMaxSeqIdRequest,
        Pull.GetGrpSysMaxSeqIdRequest.Builder,
        Pull.GetGrpSysMaxSeqIdResponse> {

    private final String topic;

    private final long groupId;

    private final RichCompletionArg<Long> completion;

    public RPCFetchSharedMaxSeqId(String topic, long groupId, RichCompletionArg<Long> completion) {
        this.topic = topic;
        this.groupId = groupId;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "GetGrpSysMaxSeqId";
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.GetGrpSysMaxSeqIdResponse res) {
        return super.describeHummerResponse(res);
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.GetGrpSysMaxSeqIdRequest.Builder builder) throws Throwable {

        builder.setGroupId(groupId).setTopic(topic).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.GetGrpSysMaxSeqIdResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion, res.getMaxSeqId());
    }

    @Override
    public void handleHummerError(@Nullable Pull.GetGrpSysMaxSeqIdResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

}
