package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

public class RPCFetchPrivateMaxSeqId extends IMRPC<Pull.GetMaxSeqIdRequest,
        Pull.GetMaxSeqIdRequest.Builder,
        Pull.GetMaxSeqIdResponse> {

    private final String topic;

    private final RichCompletionArg<Long> completion;

    public RPCFetchPrivateMaxSeqId(String topic, RichCompletionArg<Long> completion) {
        this.topic = topic;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "GetMaxSeqId";
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.GetMaxSeqIdRequest.Builder builder) throws Throwable {
        builder.setTopic(topic).build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.GetMaxSeqIdResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion, res.getMaxSeqId());
    }

    @Override
    public void handleHummerError(@Nullable Pull.GetMaxSeqIdResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.GetMaxSeqIdResponse res) {
        return super.describeHummerResponse(res);
    }
}
