package com.hummer.im._internals.chatsvc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.History;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.completion.CompletionUtils;


public class RPCFetchMessageSize extends IMRPC<History.ReverseCountChatHistoryRequest,
        History.ReverseCountChatHistoryRequest.Builder, History.ReverseCountChatHistoryResponse> {

    RPCFetchMessageSize(@NonNull Identifiable target,
                        @NonNull Long startTimestamp,
                        @NonNull Long endTimestamp,
                        @Nullable RichCompletionArg<Long> completion) {
        this.target = target;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.completion = completion;
    }

    @Override
    public void buildHummerRequest(@NonNull History.ReverseCountChatHistoryRequest.Builder builder) {
        builder.setToIdType(makeStringFrom(target))
                .setToId(target.getId())
                .setBeginTimestamp(startTimestamp)
                .setEndTimestamp(endTimestamp)
                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull History.ReverseCountChatHistoryResponse res) {
        CompletionUtils.dispatchSuccess(completion, (long) res.getCount());
    }

    @Override
    public void handleHummerError(@Nullable History.ReverseCountChatHistoryResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull History.ReverseCountChatHistoryResponse res) {
        return new StringChain().acceptNullElements()
                .add("code", res.getCode())
                .add("msg", res.getMsg())
                .toString();
    }

    @Override
    public String getHummerFunction() {
        return "ReverseCountChatHistory";
    }

    private String makeStringFrom(Identifiable target) {
        if (target instanceof User) {
            return "user";
        } else if (target instanceof Group) {
            return "group";
        } else if (target instanceof AppSession) {
            return "app/" + ((AppSession) target).getType();
        }
        return null;
    }

    private final Identifiable target;
    private final Long startTimestamp;
    private final Long endTimestamp;
    private final RichCompletionArg<Long> completion;
}
