package com.hummer.im._internals.blacklist;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.BuddyOuterClass;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;
import com.hummer.im.model.completion.CompletionUtils;


public final class RPCUnblockUser extends IMRPC<
        BuddyOuterClass.RemoveBlacklistRequest,
        BuddyOuterClass.RemoveBlacklistRequest.Builder,
        BuddyOuterClass.RemoveBlacklistResponse
        > {

    RPCUnblockUser(User user, RichCompletion completion) {
        this.user = user;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "RemoveBlacklist";
    }

    @Override
    public void buildHummerRequest(@NonNull BuddyOuterClass.RemoveBlacklistRequest.Builder builder) {
        builder.setUid(user.getId());
    }

    @Override
    public String describeHummerRequest(BuddyOuterClass.RemoveBlacklistRequest req) {
        return "blocked: " + user;
    }

    @Override
    public void handleHummerSuccess(@NonNull BuddyOuterClass.RemoveBlacklistResponse res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable BuddyOuterClass.RemoveBlacklistResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull BuddyOuterClass.RemoveBlacklistResponse res) {
        return null;
    }

    private final User       user;
    private final RichCompletion completion;
}