/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.ReflectionExt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServiceProvider {
    private static final String TAG = "ServiceProvider";
    private static boolean isLoaded = false;
    private static final Set<ModuleLoader> loaders = new HashSet<ModuleLoader>();
    private static final HashMap<Class, Service> services = new HashMap();

    public static void register(Class<?> interfaceClass, Service service) {
        services.put(interfaceClass, service);
    }

    public static <Interface> Interface get(Class<Interface> serviceClass) {
        if (serviceClass == null) {
            Log.e(TAG, Trace.method("get").info("Exception", "null"));
            return null;
        }
        if (services.isEmpty()) {
            ServiceProvider.loadServicesIfNeeded("com.hummer.im");
        }
        for (Map.Entry<Class, Service> impl : services.entrySet()) {
            if (!serviceClass.isAssignableFrom(impl.getKey())) continue;
            return (Interface)impl.getValue();
        }
        Service service = services.get(serviceClass);
        if (service == null) {
            Log.e(TAG, Trace.method("get").info("Service Not Found:", serviceClass.getName()));
        }
        return (Interface)service;
    }

    public static void loadServicesIfNeeded(String packageName) {
        if (isLoaded) {
            return;
        }
        Set<Class<?>> loaderClasses = ReflectionExt.loadClasses(packageName, Object.class, new ReflectionExt.Filter(){

            @Override
            public boolean shouldAccept(String className) {
                String simpleName = className.substring(className.lastIndexOf(".") + 1);
                return simpleName.startsWith("SP") && simpleName.endsWith("ModuleLoader");
            }
        });
        try {
            ServiceProvider.registerServicesByModuleLoaders(loaderClasses);
        }
        catch (Exception e) {
            Log.e(TAG, Trace.method("loadServicesIfNeeded").msg("Fail loading services" + e.getLocalizedMessage()));
        }
        isLoaded = true;
    }

    private static void registerServicesByModuleLoaders(Set<Class<?>> loaderClasses) throws InstantiationException, IllegalAccessException {
        for (Class<?> loaderClazz : loaderClasses) {
            ModuleLoader loader = (ModuleLoader)loaderClazz.newInstance();
            loader.initModule();
            loaders.add(loader);
            Map<Class, Service> services = loader.getServices();
            for (Map.Entry<Class, Service> entry : services.entrySet()) {
                ServiceProvider.register(entry.getKey(), entry.getValue());
                entry.getValue().initService();
            }
        }
    }

    public static interface Service {
        public void initService();
    }

    public static interface ModuleLoader {
        public void initModule();

        public void deInitModule();

        public Map<Class, Service> getServices();
    }
}

