/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import android.content.Context;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.bridge.helper.HummerEngine;
import com.hummer.im._internals.utility.DispatchQueue;
import java.lang.ref.WeakReference;

public final class HMRContext {
    public static final DispatchQueue work = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_core"));
    public static Long appId;
    public static String region;
    public static WeakReference<Context> appContext;

    public static Context getAppContext() {
        return (Context)appContext.get();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static void reportReturnCode(final String function, long beginTime, final int code) {
        final long rtt = System.currentTimeMillis() - beginTime;
        work.async(new Runnable(){

            @Override
            public void run() {
                HummerEngine.getInstance().reportReturnCode(function, rtt, code);
            }
        });
    }

    public static void reportReturnCode(String function, long beginTime) {
        HMRContext.reportReturnCode(function, beginTime, ErrorEnum.OK.getCode());
    }

    public static void reportReturnCode(String function, long beginTime, Error error) {
        if (error != null) {
            HMRContext.reportReturnCode(function, beginTime, error.code);
        }
    }
}

