/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.DispatchQueue;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccessArg;

public final class HMRCompletionArg<T> {
    private static final String TAG = "RichCompletionArg";
    private final DispatchQueue dispatchQueue;
    private OnFailure failureHandler;
    private OnSuccessArg<T> successHandler;

    public HMRCompletionArg(final RequestId requestId, final HMR.CompletionArg<T> completion) {
        Looper looper = Looper.myLooper();
        this.dispatchQueue = looper == Looper.getMainLooper() ? new DispatchQueue(new DispatchQueue.LooperHandlerProvider(Looper.getMainLooper())) : DispatchQueue.direct;
        this.onSuccess(new OnSuccessArg<T>(){

            @Override
            public void onSuccess(T result) {
                if (completion != null) {
                    Log.i(HMRCompletionArg.TAG, Trace.method(HMRCompletionArg.TAG).msg("Success").info("hummerRequestId", requestId));
                    completion.onSuccess(result);
                }
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                if (completion != null) {
                    Log.i(HMRCompletionArg.TAG, Trace.method(HMRCompletionArg.TAG).msg("Fail").info("hummerRequestId", requestId).info("Error", error.toString()));
                    completion.onFailed(error);
                }
            }
        });
    }

    public HMRCompletionArg(@NonNull Handler handler) {
        this.dispatchQueue = new DispatchQueue(new DispatchQueue.LooperHandlerProvider(handler.getLooper()));
    }

    public HMRCompletionArg<T> onSuccess(@NonNull OnSuccessArg<T> success) {
        this.successHandler = success;
        return this;
    }

    public HMRCompletionArg<T> onFailure(@NonNull OnFailure failure) {
        this.failureHandler = failure;
        return this;
    }

    void dispatchSuccess(@NonNull T result) {
        final T finalResult = result;
        this.dispatchQueue.async(new Runnable(){

            @Override
            public void run() {
                if (HMRCompletionArg.this.successHandler != null) {
                    HMRCompletionArg.this.successHandler.onSuccess(finalResult);
                } else {
                    Log.i(HMRCompletionArg.TAG, Trace.method("dispatchSuccess").msg("dispatchQueue async, success handler = null"));
                }
            }
        });
    }

    void dispatchFailure(@NonNull Error error) {
        final Error finalError = error;
        this.dispatchQueue.async(new Runnable(){

            @Override
            public void run() {
                if (HMRCompletionArg.this.failureHandler != null) {
                    HMRCompletionArg.this.failureHandler.onFailure(finalError);
                } else {
                    Log.i(HMRCompletionArg.TAG, Trace.method("dispatchFailure").msg("dispatchQueue async, failure handler = null"));
                }
            }
        });
    }
}

