/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import java.util.concurrent.Semaphore;

public final class DispatchQueue {
    public static final DispatchQueue main = new DispatchQueue(new LooperHandlerProvider(Looper.getMainLooper()));
    public static final DispatchQueue direct = new DispatchQueue(new WorkerHandler("hmr_callBack"));
    private static final String TAG = "DispatchQueue";
    private final Handler handler;

    public void async(final @NonNull Runnable runnable) {
        if (this.handler == null) {
            runnable.run();
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
            }
        });
    }

    public void sync(final @NonNull Runnable runnable) {
        boolean sameLooper;
        if (this.handler == null) {
            runnable.run();
            return;
        }
        boolean bl = sameLooper = Looper.myLooper() == this.handler.getLooper();
        if (sameLooper) {
            runnable.run();
        } else {
            final Semaphore semaphore = new Semaphore(0);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.release();
                }
            });
            semaphore.acquireUninterruptibly(1);
        }
    }

    public void asyncAfter(int delayMillis, @NonNull Runnable runnable) {
        if (this.handler == null) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            runnable.run();
        } else {
            this.handler.postDelayed(runnable, (long)delayMillis);
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public DispatchQueue() {
        this.handler = null;
    }

    public DispatchQueue(HandlerProvider provider) {
        this.handler = provider.getHandler();
    }

    public static class WorkerHandler
    implements HandlerProvider {
        private final String threadName;

        public WorkerHandler(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Handler getHandler() {
            HandlerThread thread = new HandlerThread(this.threadName);
            thread.start();
            return new Handler(thread.getLooper());
        }
    }

    public static class LooperHandlerProvider
    implements HandlerProvider {
        private final Handler handler;

        public LooperHandlerProvider(@NonNull Looper looper) {
            this.handler = new Handler(looper);
        }

        @Override
        public Handler getHandler() {
            return this.handler;
        }
    }

    public static interface HandlerProvider {
        public Handler getHandler();
    }
}

