/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRCompletionArg;

public final class CompletionUtils {
    public static void dispatchSuccess(HMRCompletion completion) {
        if (completion != null) {
            completion.dispatchSuccess();
        }
    }

    public static void dispatchFailure(HMRCompletion completion, Error error) {
        if (completion != null) {
            completion.dispatchFailure(error);
        }
    }

    public static <T> void dispatchSuccess(HMRCompletionArg<T> completion, T result) {
        if (completion != null) {
            completion.dispatchSuccess(result);
        } else {
            Log.i("CompletionUtils", Trace.method("dispatchSuccess").msg("dispatchQueue async, success completion = null"));
        }
    }

    public static <T> void dispatchFailure(HMRCompletionArg<T> completion, Error error) {
        if (completion != null) {
            completion.dispatchFailure(error);
        } else {
            Log.i("CompletionUtils", Trace.method("dispatchFailure").msg("dispatchQueue async, failure completion = null"));
        }
    }
}

