/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TextUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String bytes2hex(byte[] data) {
        char[] str = new char[data.length * 2];
        int k = 0;
        for (int i = 0; i < data.length; ++i) {
            byte byte0 = data[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static String length2DecimalChar(int length) {
        String lenStr = TextUtils.format8length(length);
        return lenStr;
    }

    private static String format8length(int len) {
        StringBuffer sb = new StringBuffer(8);
        int r = 8 - (len + "").length();
        while (r-- > 0) {
            sb.append(0);
        }
        sb.append(len);
        return sb.toString();
    }

    public static byte[] md5byte(byte[] source) {
        MessageDigest md = MD5_DIGEST.get();
        md.reset();
        md.update(source);
        byte[] tmp = md.digest();
        return tmp;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !TextUtils.isBlank(cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !TextUtils.isEmpty(cs);
    }
}

