/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.report.statis.AbstractStatisHttpUtil;
import com.hummer.im._internals.report.statis.AesCipher;
import com.hummer.im._internals.report.statis.Base64Util;
import com.hummer.im._internals.report.statis.RsaCipher;
import com.hummer.im._internals.report.statis.Util;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Locale;

public class StatisHttpEncryptUtil
extends AbstractStatisHttpUtil {
    private static final String RSA_PUB_KEY = "MCwwDQYJKoZIhvcNAQEBBQADGwAwGAIRAMRSvSVZEbyQwtFwNtNiZKkCAwEAAQ==";
    private static final String URL_PARAM = "act=mbsdkdata&smkdata=$smkdata&EC=$EC&appkey=$appkey&item=$item";
    private static final String URL_FORMAT = "http://%s/c.gif";
    private static final String DEFAULT_URL_HOST = "mlog.hiido.com";
    private String mLastHost;
    private String mLastSmkData;
    private static final String[] ADDRESSES = new String[]{"14.17.112.232", "14.17.112.233", "14.17.112.234", "14.17.112.235", "14.17.112.236", "14.17.112.237"};
    private String mUrlHost;
    private String mUrlService;
    private String[] mUrlAddress;
    private RsaCipher mRsaCipher = null;

    public StatisHttpEncryptUtil(String urlHost, String[] urlAddress) {
        this.mUrlAddress = urlAddress == null ? ADDRESSES : urlAddress;
        this.mUrlHost = urlHost == null ? DEFAULT_URL_HOST : urlHost;
        this.mUrlService = String.format(URL_FORMAT, this.mUrlHost);
    }

    @Override
    protected String[] getUrlAddress() {
        return this.mUrlAddress;
    }

    @Override
    protected String getUrlFormat() {
        return URL_FORMAT;
    }

    @Override
    protected String getUrlService() {
        return this.mUrlService;
    }

    private RsaCipher getRsaCipher() throws Exception {
        if (this.mRsaCipher == null) {
            byte[] keyBytes = Base64Util.decode(RSA_PUB_KEY);
            ByteArrayInputStream bis = new ByteArrayInputStream(keyBytes);
            RsaCipher rc = new RsaCipher();
            rc.loadPublicKey(bis);
            this.mRsaCipher = rc;
        }
        return this.mRsaCipher;
    }

    @Override
    protected boolean sendContent(String url, String content, int tryTimes) {
        this.mThrowable = null;
        this.mLastHost = null;
        this.mLastSmkData = null;
        int initialTimes = tryTimes;
        String encryptUrl = String.format("%s?%s", url, URL_PARAM);
        String encryptContent = content;
        try {
            String aesKey = "";
            String data = encryptContent;
            aesKey = Util.getRandStringEx(4);
            AesCipher aesCipher = new AesCipher(aesKey.getBytes());
            data = aesCipher.encryptTlogBytesBase64(data.getBytes("UTF-8"));
            aesCipher = null;
            encryptUrl = String.format("%s&enc=b64", encryptUrl);
            aesKey = this.getRsaCipher().encryptTlogAesKey(aesKey.getBytes());
            encryptContent = data;
            encryptUrl = encryptUrl.replace("$smkdata", aesKey);
            encryptUrl = encryptUrl.replace("$appkey", Util.parseParam(content, "appkey"));
            encryptUrl = encryptUrl.replace("$item", Util.parseParam(content, "act"));
            this.mLastSmkData = aesKey;
            this.mLastHost = new URI(url).getHost();
        }
        catch (Throwable e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report encrypt exception = %s,statusCode=%s", e, String.valueOf(this.getLastStatusCode())));
            this.mThrowable = e;
            return false;
        }
        String tmpEncryptUrl = encryptUrl;
        do {
            try {
                encryptUrl = tmpEncryptUrl.replace("$EC", this.lastTryTimes + "");
                if (initialTimes != tryTimes) {
                    Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Try again to send %s with url %s, tried times %d.", encryptContent, encryptUrl, initialTimes - tryTimes));
                }
                ++this.lastTryTimes;
                if (this.post(encryptUrl, encryptContent)) {
                    this.mThrowable = null;
                    return true;
                }
                Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Failed to send %s to %s.", encryptContent, encryptUrl));
            }
            catch (Throwable e) {
                this.mThrowable = e;
                Log.i(HiidoReporter.TAG, String.format(Locale.US, "report guid:%s. http statis exception %s", Util.parseParam(content, "guid"), e));
            }
        } while (tryTimes-- > 0);
        return false;
    }
}

