/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.report.statis.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class StatisContent {
    public static final String ACT = "act";
    public static final String TIME = "time";
    public static final String APPKEY = "appkey";
    public static final String KEY = "key";
    protected static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            boolean equals1 = StatisContent.ACT.equals(o1);
            boolean equals2 = StatisContent.ACT.equals(o2);
            if (!equals1 && !equals2) {
                return o1.compareTo(o2);
            }
            if (!equals1 && equals2) {
                return 1;
            }
            if (equals1 && !equals2) {
                return -1;
            }
            if (equals1 && equals2) {
                return 0;
            }
            return 0;
        }
    };
    protected TreeMap<String, String> raw = new TreeMap(COMPARATOR);

    public String put(String key, int value) {
        return this.put(key, String.valueOf(value));
    }

    public String put(String key, long value) {
        return this.put(key, String.valueOf(value));
    }

    public String put(String key, double value) {
        return this.put(key, String.valueOf(value));
    }

    public String get(String key) {
        return this.raw.get(key);
    }

    public boolean containsKey(String key) {
        return this.raw.containsKey(key);
    }

    public synchronized String put(String key, String value) {
        if (Util.empty(key)) {
            Log.i(HiidoReporter.TAG, String.format("report key is invalid for value %s", value));
            return null;
        }
        value = Util.asEmptyOnNull(value);
        return this.raw.put(key, value);
    }

    public synchronized String put(String key, String value, boolean isCover) {
        if (Util.empty(key)) {
            Log.i(HiidoReporter.TAG, String.format("report key is invalid for value %s", value));
            return null;
        }
        value = Util.asEmptyOnNull(value);
        if (isCover) {
            return this.raw.put(key, value);
        }
        if (this.raw.containsKey(key)) {
            return this.raw.get(key);
        }
        return this.raw.put(key, value);
    }

    public synchronized String getContent() {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> localRaw = this.raw;
        for (Map.Entry<String, String> e : localRaw.entrySet()) {
            String value = e.getValue();
            if (Util.empty(value)) {
                Log.i(HiidoReporter.TAG, String.format("report No value for key %s", e.getKey()));
                continue;
            }
            sb.append(e.getKey());
            sb.append("=");
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                Log.i(HiidoReporter.TAG, String.format("report encoding fail for key %s", e.getKey()));
            }
            sb.append("&");
        }
        if (sb.length() == 0) {
            Log.i(HiidoReporter.TAG, String.format("report Warn : http content may be null?", new Object[0]));
            sb = null;
            return null;
        }
        if (sb.length() > 0) {
            sb.append("hd_p=E&");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        String tmp = sb.toString();
        sb.setLength(0);
        sb = null;
        return tmp;
    }

    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    public StatisContent copy() {
        StatisContent dest = new StatisContent();
        dest.raw = new TreeMap(COMPARATOR);
        dest.raw.putAll(this.raw);
        return dest;
    }
}

