/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import com.hummer.im._internals.report.statis.TextUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RsaCipher {
    private static final String RSA_PADDING = "RSA/ECB/PKCS1Padding";
    private PublicKey publicKey;
    private int publicMflen = 16;
    private int publicMtail = 5;
    private final ThreadLocal<Cipher> rsaCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(RsaCipher.RSA_PADDING);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public void loadPublicKey(InputStream in) throws Exception {
        byte[] keyBytes = RsaCipher.readAllBytes(in);
        try {
            PublicKey publicKey;
            this.publicKey = publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public String encryptTlogAesKey(byte[] keyContent) throws Exception {
        if (keyContent == null || keyContent.length == 0) {
            return null;
        }
        byte[] enBytes = this.encrypt(keyContent);
        StringBuilder builder = new StringBuilder(8 + enBytes.length * 2);
        builder.append(TextUtils.length2DecimalChar(keyContent.length));
        builder.append(TextUtils.bytes2hex(enBytes));
        return builder.toString();
    }

    public byte[] encrypt(byte[] content) throws Exception {
        int certifSize = content.length;
        int pad = certifSize % this.publicMtail;
        int total = pad != 0 ? certifSize + this.publicMtail - pad : certifSize;
        int bufferEnd = content.length;
        if (pad != 0) {
            byte[] newContent = new byte[total];
            System.arraycopy(content, 0, newContent, 0, content.length);
            content = newContent;
        }
        int outlen = total / this.publicMtail * this.publicMflen;
        byte[] outByte = new byte[outlen];
        int contentStep = 0;
        int outStep = 0;
        int icount = 0;
        try {
            byte[] tempEncrypt;
            while (contentStep < content.length && (icount = bufferEnd - contentStep) >= this.publicMtail) {
                tempEncrypt = this.encrypt(content, contentStep, this.publicMtail, this.publicKey);
                System.arraycopy(tempEncrypt, 0, outByte, outStep, tempEncrypt.length);
                contentStep += this.publicMtail;
                outStep += this.publicMflen;
            }
            if (icount > 0 && contentStep < content.length) {
                content[contentStep + this.publicMtail - 1] = (byte)(this.publicMtail - icount);
                tempEncrypt = this.encrypt(content, contentStep, this.publicMtail, this.publicKey);
                System.arraycopy(tempEncrypt, 0, outByte, outStep, tempEncrypt.length);
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        return outByte;
    }

    private byte[] encrypt(byte[] input, int inputOffset, int inputLen, Key key) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        Cipher cipher = this.rsaCipher.get();
        cipher.init(1, key);
        byte[] en = cipher.doFinal(input, inputOffset, inputLen);
        return en;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        ArrayList<Byte> orig = new ArrayList<Byte>(512);
        DataInputStream dis = new DataInputStream(in);
        int b = -1;
        while ((b = dis.read()) != -1) {
            orig.add((byte)b);
        }
        byte[] keyBytes = new byte[orig.size()];
        for (int i = 0; i < keyBytes.length; ++i) {
            keyBytes[i] = (Byte)orig.get(i);
        }
        return keyBytes;
    }
}

