/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.report.statis.IStatisHttpUtil;
import com.hummer.im._internals.report.statis.MetricsCount;
import com.hummer.im._internals.report.statis.MetricsPkg;
import com.hummer.im._internals.report.statis.MetricsResult;
import com.hummer.im._internals.report.statis.StatisContent;
import com.hummer.im._internals.report.statis.Util;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetricsWorker {
    public static final String ACT = "mmetric";
    private static final String TAG = "MetricsWorker";
    private int maxCount = 10;
    private IStatisHttpUtil mMetircs;
    private IStatisHttpUtil mHiido;
    private MetricsPkg pkg;
    private AtomicInteger count = new AtomicInteger(0);
    private String appKey;
    private String version;
    private String from;
    private boolean mTimerStart = false;
    private static final String KEY_MAGIC = "HiidoYYSystem";

    public MetricsWorker() {
        this.pkg = new MetricsPkg(this.maxCount);
    }

    public void init(String appKey, String version, String from) {
        this.appKey = appKey;
        this.version = version;
        this.from = from;
    }

    public void setStatisHttpUtil(IStatisHttpUtil metrics, IStatisHttpUtil hiido) {
        this.mMetircs = metrics;
        this.mHiido = hiido;
    }

    private void changePkgMaxCount(boolean succ) {
        this.maxCount = succ ? (this.maxCount += 5) : (this.maxCount -= 5);
        if (this.maxCount > 100) {
            this.maxCount = 100;
        }
        if (this.maxCount < 5) {
            this.maxCount = 5;
        }
        Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Metrics next pkg piece count: %d. ", this.maxCount));
    }

    private void checkPkgWithTimer() {
        if (this.count.get() > 0 && !this.mTimerStart) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "post timer to report Metrics pkg count: %d", this.count.get()));
            this.mTimerStart = true;
            HiidoReporter.reportQueue.asyncAfter(120000, new Runnable(){

                @Override
                public void run() {
                    MetricsWorker.this.onTimer();
                    MetricsWorker.this.mTimerStart = false;
                }
            });
        }
    }

    private void onTimer() {
        if (this.count.get() > 0) {
            try {
                Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Metrics onTimer piece count: %d. ", this.count.get()));
                MetricsPkg p = this.pkg;
                this.pkg = new MetricsPkg(this.maxCount);
                this.count.set(0);
                this.sendPkg(p);
            }
            catch (Throwable e) {
                Log.e(TAG, Trace.method("onTimer").info("error", e.getMessage()));
            }
        }
    }

    private void sendPkg(MetricsPkg pkg) {
        try {
            List<JSONObject> obj = pkg.toJson();
            for (JSONObject one : obj) {
                String str = this.toContent(one);
                if (str == null) continue;
                this.sendHttp(str);
            }
        }
        catch (Throwable e) {
            Log.e(TAG, Trace.method("sendPkg").info("error", e.getMessage()));
        }
    }

    private void sendHttp(String content) {
        try {
            content = String.format(Locale.US, "%s&hd_stime=%d", content, Util.wallTimeMillis());
            boolean suc = this.mMetircs.sendSync(content);
            this.changePkgMaxCount(suc);
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Metrics %B to send command.size: %d", suc, content.length()));
        }
        catch (Throwable e) {
            Log.e(TAG, Trace.method("sendHttp").info("error", e.getMessage()));
        }
    }

    private String toContent(JSONObject param) {
        try {
            long l;
            StatisContent content = new StatisContent();
            String timeStamp = String.valueOf(Util.wallTimeSec());
            content.put("act", ACT);
            content.put("time", timeStamp);
            content.put("key", this.calKey(ACT, timeStamp));
            content.put("appkey", this.appKey);
            content.put("sys", 2);
            content.put("ver", this.version);
            content.put("sdkver", this.version);
            try {
                l = param.getLong("clienttime");
            }
            catch (Throwable e) {
                l = System.currentTimeMillis();
            }
            content.put("clienttime", String.valueOf(l / 1000L));
            JSONArray req = null;
            if (param.has("reqdata")) {
                req = param.getJSONArray("reqdata");
            }
            JSONArray counterdata = null;
            if (param.has("counterdata")) {
                counterdata = param.getJSONArray("counterdata");
            }
            if (req != null) {
                content.put("reqdata", this.notNull(req.toString()));
            }
            if (counterdata != null) {
                content.put("counterdata", this.notNull(counterdata.toString()));
            }
            return content.toString();
        }
        catch (Throwable e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
            return null;
        }
    }

    private String notNull(String str) {
        return str == null ? "" : str;
    }

    private String calKey(String act, String time) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(act);
        sBuilder.append(time);
        sBuilder.append(KEY_MAGIC);
        String raw = sBuilder.toString();
        sBuilder.setLength(0);
        try {
            return Util.encryptMD5(raw).toLowerCase(Locale.getDefault());
        }
        catch (Throwable e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsPkg cutPiece() {
        MetricsPkg p = null;
        MetricsWorker metricsWorker = this;
        synchronized (metricsWorker) {
            int c = this.count.get();
            if (c > this.maxCount) {
                p = this.pkg;
                this.pkg = new MetricsPkg(this.maxCount);
                this.count.set(0);
            }
        }
        return p;
    }

    public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
        MetricsPkg pkg;
        MetricsResult result = new MetricsResult(scode, uri, timeConsumption, code);
        this.pkg.addMetricsResult(result);
        int c = this.count.incrementAndGet();
        if (c > this.maxCount && (pkg = this.cutPiece()) != null) {
            this.sendPkg(pkg);
        }
        this.checkPkgWithTimer();
    }

    public void reportCount(int scode, String uri, String countName, long count) {
        this.reportCount(scode, uri, countName, count, 1);
    }

    public void reportCount(int scode, String uri, String countName, long count, int times) {
        MetricsPkg pkg;
        int add;
        MetricsCount c = new MetricsCount(scode, uri, countName);
        c.count(count, times);
        if (this.pkg.addCounter(c) && (add = this.count.incrementAndGet()) > this.maxCount && (pkg = this.cutPiece()) != null) {
            this.sendPkg(pkg);
        }
        this.checkPkgWithTimer();
    }

    public void reportReturnCodeTemporary(int scode, String uri, long timeConsumption, String code) {
        Log.i(HiidoReporter.TAG, String.format(Locale.US, "report return code uri: %s, code: %s", uri, code));
        MetricsPkg pkg = new MetricsPkg(0);
        MetricsResult result = new MetricsResult(scode, uri, timeConsumption, code);
        pkg.addMetricsResult(result);
        this.sendPkg(pkg);
    }

    public void reportHiidoTemporary(String act, Map<String, Integer> intFields, Map<String, Long> longFields, Map<String, String> stringFields) {
        StatisContent content = new StatisContent();
        if (intFields != null) {
            for (Map.Entry<String, Number> entry : intFields.entrySet()) {
                content.put(entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (longFields != null) {
            for (Map.Entry<String, Object> entry : longFields.entrySet()) {
                content.put(entry.getKey(), (Long)entry.getValue());
            }
        }
        if (stringFields != null) {
            for (Map.Entry<String, Object> entry : stringFields.entrySet()) {
                content.put(entry.getKey(), (String)entry.getValue());
            }
        }
        content.put("appkey", this.appKey);
        String timeStamp = String.valueOf(Util.wallTimeSec());
        content.put("act", act);
        content.put("time", timeStamp);
        content.put("key", this.calKey(act, timeStamp));
        this.mHiido.sendSync(content.getContent());
    }
}

