/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.report.statis.IJsonSerialize;
import com.hummer.im._internals.report.statis.MetricsCount;
import com.hummer.im._internals.report.statis.MetricsResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsPkg {
    private ConcurrentLinkedQueue<IJsonSerialize> reqData = new ConcurrentLinkedQueue();
    private HashMap<String, MetricsCount> counterData = new HashMap();
    private int maxCount;

    public MetricsPkg(int maxCount) {
        this.maxCount = maxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCounter(MetricsCount counter) {
        String key = counter.getKey();
        MetricsCount c = this.counterData.get(key);
        boolean ret = false;
        if (c == null) {
            HashMap<String, MetricsCount> hashMap = this.counterData;
            synchronized (hashMap) {
                MetricsCount one = this.counterData.get(key);
                if (one == null) {
                    this.counterData.put(key, (MetricsCount)counter.clone());
                    ret = true;
                } else {
                    one.count(counter.getValue(), counter.getInvokeCount());
                }
            }
        } else {
            c.count(counter.getValue(), counter.getInvokeCount());
        }
        return ret;
    }

    public void addMetricsResult(MetricsResult req) {
        this.reqData.add(req);
    }

    public List<JSONObject> toJson() {
        JSONObject obj;
        ArrayList<JSONObject> arr = new ArrayList<JSONObject>();
        long time = System.currentTimeMillis();
        int count = 0;
        Iterator<IJsonSerialize> iterator1 = this.reqData.iterator();
        JSONArray reqs = new JSONArray();
        while (iterator1.hasNext()) {
            reqs.put((Object)iterator1.next().toJson());
            if (++count < this.maxCount) continue;
            JSONObject obj2 = this.cutPiece(reqs, null, time);
            if (obj2 != null) {
                arr.add(obj2);
            }
            reqs = new JSONArray();
            count = 0;
        }
        Iterator<MetricsCount> iterator2 = this.counterData.values().iterator();
        JSONArray cs = new JSONArray();
        while (iterator2.hasNext()) {
            cs.put((Object)iterator2.next().toJson());
            if (++count < this.maxCount) continue;
            obj = this.cutPiece(reqs, cs, time);
            if (obj != null) {
                arr.add(obj);
            }
            reqs = new JSONArray();
            cs = new JSONArray();
            count = 0;
        }
        if (reqs.length() + cs.length() > 0 && (obj = this.cutPiece(reqs, cs, time)) != null) {
            arr.add(obj);
        }
        return arr;
    }

    private JSONObject cutPiece(JSONArray reqs, JSONArray counts, long time) {
        JSONObject ret = new JSONObject();
        try {
            if (reqs != null) {
                ret.put("reqdata", (Object)reqs);
            }
            if (counts != null) {
                ret.put("counterdata", (Object)counts);
            }
            ret.put("clienttime", time);
            return ret;
        }
        catch (JSONException e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
            return null;
        }
    }
}

