/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.report.statis.IJsonSerialize;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsCount
implements IJsonSerialize,
Cloneable {
    private int scode;
    private String uri;
    private String counterName;
    private long value;
    private int invokeCount;

    public MetricsCount(int scode, String uri, String counterName) {
        this.scode = scode;
        this.uri = uri;
        this.counterName = counterName;
    }

    public int getInvokeCount() {
        return this.invokeCount;
    }

    public long getValue() {
        return this.value;
    }

    public synchronized void count(long value, int invoke) {
        this.value += value;
        this.invokeCount += invoke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject toJson() {
        long in;
        long va;
        MetricsCount metricsCount = this;
        synchronized (metricsCount) {
            va = this.value;
            in = this.invokeCount;
        }
        if (va == 0L && in == 0L) {
            return null;
        }
        try {
            JSONObject obj = new JSONObject();
            obj.put("scode", this.scode);
            obj.put("uri", (Object)URLEncoder.encode(this.uri, "utf-8"));
            obj.put("counterName", (Object)URLEncoder.encode(this.counterName, "utf-8"));
            obj.put("value", va);
            obj.put("invokecount", (int)in);
            return obj;
        }
        catch (JSONException e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        }
        catch (UnsupportedEncodingException e) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        }
        return null;
    }

    public String getKey() {
        return String.format("%d&%s&%s", this.scode, this.uri, this.counterName);
    }

    protected Object clone() {
        MetricsCount counter = new MetricsCount(this.scode, this.uri, this.counterName);
        counter.value = this.value;
        counter.invokeCount = this.invokeCount;
        return counter;
    }
}

