/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report.statis;

import android.text.TextUtils;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.report.statis.HttpUtil;
import com.hummer.im._internals.report.statis.IStatisHttpUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;

public abstract class AbstractStatisHttpUtil
implements IStatisHttpUtil {
    protected int mRetryTimeHost = 2;
    protected int mTryTimeIp = 2;
    protected Throwable mThrowable;
    protected String testServer;
    protected int lastTryTimes;
    protected int statusCode;
    protected String reasonPhrase;

    protected String getServerAddr() {
        String ret = this.testServer == null || this.testServer.length() == 0 ? this.getUrlService() : this.testServer;
        return ret;
    }

    protected String[] getFallbackIps() {
        return this.testServer == null || this.testServer.length() == 0 ? this.getUrlAddress() : new String[]{};
    }

    @Override
    public void setTestServer(String testServer) {
        this.testServer = testServer;
    }

    @Override
    public boolean sendSync(String content) {
        return this.sendSyncByTrying(content);
    }

    protected boolean sendSyncByTrying(String content) {
        if (this.sendContent(this.getServerAddr(), content, this.mRetryTimeHost)) {
            return true;
        }
        Object[] ips = this.getFallbackIps();
        Log.i(HiidoReporter.TAG, String.format(Locale.US, "report fallback IPs : %s", TextUtils.join((CharSequence)" ", (Object[])ips)));
        if (ips == null || ips.length == 0) {
            return false;
        }
        int ipTimes = this.mTryTimeIp;
        int index = 0;
        String url = null;
        while (ipTimes-- > 0) {
            index = new Random().nextInt(ips.length);
            url = this.asUrl((String)ips[index]);
            if (!this.sendContent(url, content, 0)) continue;
            return true;
        }
        return false;
    }

    protected boolean get(String urlAddr, String content) throws IOException {
        return this.getByUrlConn(urlAddr, content);
    }

    protected boolean post(String urlAddr, String content) throws IOException {
        return this.postByUrlConn(urlAddr, content);
    }

    private boolean getByUrlConn(String urlAddr, String content) throws IOException {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUtil.HttpResp resp = HttpUtil.getByUrlConn(urlAddr, content);
        this.statusCode = resp.statusCode;
        this.reasonPhrase = resp.reason;
        return resp.isSucceed;
    }

    private boolean postByUrlConn(String urlAddr, String content) throws IOException {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUtil.HttpResp resp = HttpUtil.postByUrlConn(urlAddr, content);
        this.statusCode = resp.statusCode;
        this.reasonPhrase = resp.reason;
        return resp.isSucceed;
    }

    protected String asUrl(String ip) {
        return String.format(this.getUrlFormat(), ip);
    }

    @Override
    public Throwable getLastError() {
        return this.mThrowable;
    }

    @Override
    public int getLastStatusCode() {
        return this.statusCode;
    }

    protected abstract boolean sendContent(String var1, String var2, int var3);

    protected abstract String getUrlService();

    protected abstract String getUrlFormat();

    protected abstract String[] getUrlAddress();
}

