/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.report;

import android.text.TextUtils;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.report.statis.MetricsHttpEncryptUtil;
import com.hummer.im._internals.report.statis.MetricsWorker;
import com.hummer.im._internals.report.statis.StatisHttpEncryptUtil;
import com.hummer.im._internals.utility.DispatchQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class HiidoReporter {
    public static final DispatchQueue reportQueue = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_report"));
    public static String TAG = "Reporter";
    private static String host;
    private static String metricsHost;
    private static MetricsWorker metricsWorker;

    public static void setRegion(Region region) {
        switch (region) {
            case China: {
                host = "mlog.hiido.com";
                metricsHost = "klog.hiido.com";
                break;
            }
            case Overseas: {
                host = "hlog.hiido.com";
                metricsHost = "klog.hiido.com";
                break;
            }
            default: {
                Log.e("HiidoReporter", Trace.method("setRegion").info("hiido.Reporter | Unknown region: ", (Object)region));
            }
        }
        if (metricsWorker != null) {
            metricsWorker.setStatisHttpUtil(new MetricsHttpEncryptUtil(metricsHost, null), new StatisHttpEncryptUtil(host, null));
        }
    }

    public static Map<String, Field> makeFields(Map<String, Integer> intFields, Map<String, Long> longFields, Map<String, String> stringFields) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Map.Entry<String, Integer> entry : intFields.entrySet()) {
            fields.put(entry.getKey(), Field.from(entry.getValue()));
        }
        for (Map.Entry<String, Number> entry : longFields.entrySet()) {
            fields.put(entry.getKey(), Field.from((Long)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : stringFields.entrySet()) {
            fields.put(entry.getKey(), Field.from((String)entry.getValue()));
        }
        return fields;
    }

    public static void init(String appKey, String version, String from) {
        if (metricsWorker != null) {
            metricsWorker.init(appKey, version, from);
        }
    }

    public static void report(final String act, final Map<String, Field> fields) {
        Log.i(TAG, "report | " + fields);
        reportQueue.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection conn = null;
                try {
                    String query = HiidoReporter.queryString(act, fields);
                    if (query == null) {
                        return;
                    }
                    URL url = new URL(String.format(Locale.US, "https://%s/c.gif?%s", host, query));
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setReadTimeout(6000);
                    conn.setConnectTimeout(10000);
                    int responseCode = conn.getResponseCode();
                    if (responseCode != 200) {
                        String failure = HiidoReporter.getStringFromInputStream(conn.getErrorStream());
                        Log.w(TAG, "report | Failed: [" + responseCode + "] " + failure);
                    }
                }
                catch (Exception e) {
                    Log.e(TAG, "report | Exception: " + e.getLocalizedMessage());
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        });
    }

    public static void reportAct(final String act, final Map<String, Integer> intFields, final Map<String, Long> longFields, final Map<String, String> stringFields) {
        reportQueue.async(new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportHiidoTemporary(act, intFields, longFields, stringFields);
                }
                catch (Throwable e) {
                    Log.e(TAG, String.format(Locale.US, "reportStatisticContentTemporary error:%s", e.getLocalizedMessage()));
                }
            }
        });
    }

    public static void reportReturnCode(final int scode, final String uri, final long timeConsumption, final String code) {
        reportQueue.async(new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportReturnCode(scode, uri, timeConsumption, code);
                }
                catch (Throwable e) {
                    Log.e(TAG, String.format(Locale.US, "reportReturnCode error:%s", e.getLocalizedMessage()));
                }
            }
        });
    }

    private static void reportReturnCodeTemporary(final int scode, final String uri, final long timeConsumption, final String code) {
        reportQueue.async(new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportReturnCodeTemporary(scode, uri, timeConsumption, code);
                }
                catch (Throwable e) {
                    Log.e(TAG, String.format(Locale.US, "reportReturnCodeTemporary error:%s", e.getLocalizedMessage()));
                }
            }
        });
    }

    private static void reportCount(final int scode, final String uri, final String countName, final long count) {
        reportQueue.async(new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportCount(scode, uri, countName, count);
                }
                catch (Throwable e) {
                    Log.e(TAG, String.format(Locale.US, "report count error:%s", e.getLocalizedMessage()));
                }
            }
        });
    }

    private static void reportCount(final int scode, final String uri, final String countName, final long count, final int times) {
        reportQueue.async(new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportCount(scode, uri, countName, count, times);
                }
                catch (Throwable e) {
                    Log.e(TAG, String.format(Locale.US, "reportCount error:%s", e.getLocalizedMessage()));
                }
            }
        });
    }

    private static String queryString(String act, Map<String, Field> fields) throws InvalidParameterException {
        long ts = System.currentTimeMillis() / 1000L;
        String key = HiidoReporter.actionKey(act, ts);
        if (key == null) {
            return null;
        }
        ArrayList<String> components = new ArrayList<String>();
        components.add(String.format(Locale.US, "act=%s", act));
        components.add(String.format(Locale.US, "time=%d", ts));
        components.add(String.format(Locale.US, "key=%s", key));
        for (Map.Entry<String, Field> entry : fields.entrySet()) {
            Field field = entry.getValue();
            if (!HiidoReporter.isAcceptableField(field)) {
                Log.w(TAG, Trace.method("queryString").msg("Null Field: %s", entry.getKey()));
                continue;
            }
            try {
                String encodedValue = URLEncoder.encode(entry.getValue().toString(), "utf-8");
                components.add(String.format(Locale.US, "%s=%s", entry.getKey(), encodedValue));
            }
            catch (UnsupportedEncodingException e) {
                Log.w(TAG, Trace.method("queryString").msg("Invalid Field: %s = %s", entry.getKey(), field));
            }
        }
        return TextUtils.join((CharSequence)"&", components);
    }

    private static String getStringFromInputStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        is.close();
        String state = os.toString();
        os.close();
        return state;
    }

    public static String actionKey(String act, long ts) {
        if (TextUtils.isEmpty((CharSequence)act)) {
            Log.e("HiidoReporter", Trace.method("actionKey").info("act", act));
        }
        String content = act + String.valueOf(ts) + "HiidoYYSystem";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(content.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                sb.append(temp);
            }
            return sb.toString().toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isAcceptableField(Field field) {
        return field != null;
    }

    static {
        metricsWorker = new MetricsWorker();
    }

    public static class Field {
        private String value;

        public static Field from(Integer intValue) {
            return new Field(String.valueOf(intValue));
        }

        public static Field from(Long longValue) {
            return new Field(String.valueOf(longValue));
        }

        public static Field from(String stringValue) {
            return new Field(stringValue);
        }

        public String toString() {
            return this.value;
        }

        private Field(String value) {
            this.value = value;
        }
    }

    public static enum Region {
        China,
        Overseas;

    }
}

