/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.marshall;

import com.hummer.im._internals.bridge.marshall.IByteBufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;

public class MshByteBufferPool
implements IByteBufferPool {
    static final int kSize4K = 4096;
    static final int kSize8K = 8192;
    static final int kSize16K = 16384;
    static final int kSize32K = 32768;
    private ByteBufferChunk mBuffer4K = new ByteBufferChunk(4096, 8);
    private ByteBufferChunk mBuffer8K = new ByteBufferChunk(8192, 6);
    private ByteBufferChunk mBuffer16K = new ByteBufferChunk(16384, 4);
    private ByteBufferChunk mBuffer32K = new ByteBufferChunk(32768, 2);
    private HashSet<ByteBuffer> mBigBuffers = new HashSet();

    private ByteBufferChunk getBuffers(int size) {
        if (size < 0) {
            return null;
        }
        if (size <= 4096) {
            return this.mBuffer4K;
        }
        if (size <= 8192) {
            return this.mBuffer8K;
        }
        if (size <= 16384) {
            return this.mBuffer16K;
        }
        if (size <= 32768) {
            return this.mBuffer32K;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer newBuffer(int size) {
        MshByteBufferPool mshByteBufferPool = this;
        synchronized (mshByteBufferPool) {
            ByteBufferChunk buffers = this.getBuffers(size);
            if (buffers != null && buffers.mFreeCnt > 0) {
                return buffers.newBuffer();
            }
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            this.mBigBuffers.add(buffer);
            return buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeBuffer(ByteBuffer buf) {
        MshByteBufferPool mshByteBufferPool = this;
        synchronized (mshByteBufferPool) {
            ByteBufferChunk buffers = this.getBuffers(buf.capacity());
            if (buffers == null || !buffers.freeBuffer(buf)) {
                this.mBigBuffers.remove(buf);
            }
        }
    }

    @Override
    public int totalSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MshByteBufferPool mshByteBufferPool = this;
        synchronized (mshByteBufferPool) {
            this.mBigBuffers.clear();
            this.mBigBuffers = null;
            this.mBuffer4K.clear();
            this.mBuffer8K.clear();
            this.mBuffer16K.clear();
            this.mBuffer32K.clear();
            this.mBuffer4K = null;
            this.mBuffer8K = null;
            this.mBuffer16K = null;
            this.mBuffer32K = null;
        }
    }

    public class ByteBufferChunk {
        public static final int kFreeFlag = 1;
        public ByteBuffer[] mBufferBlocks = null;
        public int[] mBlockFlags = null;
        public int mFreeCnt = 0;

        public ByteBufferChunk(int blockSize, int blockCnt) {
            this.mBufferBlocks = new ByteBuffer[blockCnt];
            this.mBlockFlags = new int[blockCnt];
            this.mFreeCnt = blockCnt;
            for (int i = 0; i < blockCnt; ++i) {
                this.mBufferBlocks[i] = ByteBuffer.allocate(blockSize).order(ByteOrder.LITTLE_ENDIAN);
                this.mBlockFlags[i] = 1;
            }
        }

        public ByteBuffer newBuffer() {
            for (int i = 0; i < this.mBufferBlocks.length; ++i) {
                if ((this.mBlockFlags[i] & 1) == 0) continue;
                int n = i;
                this.mBlockFlags[n] = this.mBlockFlags[n] & 0xFFFFFFFE;
                --this.mFreeCnt;
                return this.mBufferBlocks[i];
            }
            return null;
        }

        public boolean freeBuffer(ByteBuffer buf) {
            for (int i = 0; i < this.mBufferBlocks.length; ++i) {
                if (buf != this.mBufferBlocks[i] || (this.mBlockFlags[i] & 1) != 0) continue;
                int n = i;
                this.mBlockFlags[n] = this.mBlockFlags[n] | 1;
                this.mBufferBlocks[i].clear();
                ++this.mFreeCnt;
                return true;
            }
            return false;
        }

        public void clear() {
            for (int i = 0; i < this.mBufferBlocks.length; ++i) {
                this.mBufferBlocks[i] = null;
            }
            this.mBufferBlocks = null;
            this.mBlockFlags = null;
        }
    }
}

