/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im._internals.ChatServiceImpl;
import com.hummer.im._internals.bridge.marshall.HPMarshaller;

public class HummerEvent {
    private static final int EVENT_SDK_INIT = 101;
    private static final int EVENT_LOGIN = 102;
    private static final int EVENT_LOGOUT = 103;
    private static final int EVENT_REFRESH_TOKEN = 104;
    private static final int EVENT_LOG_TEXT = 105;
    private static final int EVENT_LOG_FILE_PATH = 106;
    private static final int EVENT_SET_LOG_LEVEL = 107;
    private static final int EVENT_LOG_DISABLE_CONSOLE = 108;
    private static final int EVENT_UPLOAD_LOG = 109;
    public static final int EVENT_SET_DEBUG_MODE = 110;
    public static final int EVENT_SET_LOG_CALLBACK = 111;
    private static final int EVENT_SEND_MESSAGE = 201;
    public static final int EVENT_REFRESH_TOKEN_1 = 202;
    private static final int EVENT_REPORT_METRICS_RETURN_CODE = 203;

    public static class EventReportReturnCode
    extends EventBase {
        private String funcName;
        private long rtt;
        private int code;

        EventReportReturnCode(String funcName, long rtt, int code) {
            this.event = 203;
            this.funcName = funcName;
            this.rtt = rtt;
            this.code = code;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.funcName);
            this.pushInt64(this.rtt);
            this.pushInt(this.code);
            return super.marshall();
        }
    }

    public static class EventSendMessage
    extends EventBase {
        private long requestId;
        private ChatServiceImpl.MessagePacket packet;

        EventSendMessage(long requestId, ChatServiceImpl.MessagePacket packet) {
            this.event = 201;
            this.requestId = requestId;
            this.packet = packet != null ? packet : new ChatServiceImpl.MessagePacket();
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushInt(this.packet.getMsgType());
            this.pushInt64(this.packet.getUserId());
            this.pushInt(this.packet.getRoomId());
            this.pushString32(this.packet.getData(), "utf-8");
            this.pushString16(this.packet.getExtra());
            this.pushMap(this.packet.getKvExtra(), String.class);
            return super.marshall();
        }
    }

    public static class EventRefreshToken
    extends EventBase {
        private long requestId;
        private String token;

        EventRefreshToken(long requestId, String token) {
            this.event = 104;
            this.requestId = requestId;
            this.token = token;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushString16(this.token);
            return super.marshall();
        }
    }

    public static class EventUploadLog
    extends EventBase {
        private String note;

        EventUploadLog(String _note) {
            this.event = 109;
            this.note = _note;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.note);
            return super.marshall();
        }
    }

    public static class EventLogDisableConsole
    extends EventBase {
        private boolean disable;

        EventLogDisableConsole(boolean _disable) {
            this.event = 108;
            this.disable = _disable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.disable);
            return super.marshall();
        }
    }

    public static class EventLogSetLevel
    extends EventBase {
        private int level;

        EventLogSetLevel(int _level) {
            this.event = 107;
            this.level = _level;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.level);
            return super.marshall();
        }
    }

    public static class EventLogFilePath
    extends EventBase {
        private String filePath;

        EventLogFilePath(String _filePath) {
            this.event = 106;
            this.filePath = _filePath;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.filePath);
            return super.marshall();
        }
    }

    public static class EventLogText
    extends EventBase {
        private int level;
        private int module;
        private String moduleName;
        private String tag;
        private String text;

        EventLogText(int _level, int _module, String _moduleName, String _tag, String _text) {
            this.event = 105;
            this.level = _level;
            this.module = _module;
            this.moduleName = _moduleName;
            this.tag = _tag;
            this.text = _text;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.level);
            this.pushInt(this.module);
            this.pushString16(this.moduleName);
            this.pushString16(this.tag);
            this.pushString32(this.text);
            return super.marshall();
        }
    }

    public static class EventLogout
    extends EventBase {
        private long requestId;

        EventLogout(long requestId) {
            this.event = 103;
            this.requestId = requestId;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            return super.marshall();
        }
    }

    public static class EventLogin
    extends EventBase {
        private long requestId;
        private long uid;
        private String region;
        private String token;

        EventLogin(long requestId, long uid, String region, String token) {
            this.event = 102;
            this.requestId = requestId;
            this.uid = uid;
            this.region = region;
            this.token = token;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushInt64(this.uid);
            this.pushString16(this.region);
            this.pushString16(this.token);
            return super.marshall();
        }
    }

    public static class EventInitSdk
    extends EventBase {
        private long appId;
        private String appVersion;

        EventInitSdk(long _appId, String _appVersion) {
            this.event = 101;
            this.appId = _appId;
            this.appVersion = _appVersion;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.appId);
            this.pushString16(this.appVersion);
            return super.marshall();
        }
    }

    public static class EventBase
    extends HPMarshaller {
        public int event = 0;

        public int event() {
            return this.event;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }
}

