/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerDispatch;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im._internals.bridge.marshall.Marshallable;
import com.hummer.im._internals.log.HummerLog;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.report.HiidoReporter;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.auth.TokenProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HummerEngine
implements HummerNative.NotificationListener {
    private static HummerEngine INSTANCE = null;
    private static boolean mIsInited = false;
    private static TokenProvider mTokenProvider = null;
    private static final Set<HMR.TokenInvalidListener> mTokenInvalidListeners = new HashSet<HMR.TokenInvalidListener>();
    private static final Set<HMR.HummerListener> mHummerListeners = new HashSet<HMR.HummerListener>();
    private static final Set<KickOutHandler> mKickOutHandler = new HashSet<KickOutHandler>();
    private static Map<RequestId, HMRCompletion> mLoginCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static Map<RequestId, HMRCompletion> mLogoutCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static Map<RequestId, HMRCompletion> mRefreshTokenCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static final String TAG = "HummerEngine";
    private static final String SP_NAME = "hummer_config";
    private static final String KEY_SET_DEBUG_MODE = "set_debug_mode";

    private HummerEngine() {
        HummerNative.registerNotificationListener(this);
    }

    public static synchronized HummerEngine getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HummerEngine();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long appId) {
        HummerEngine hummerEngine = this;
        synchronized (hummerEngine) {
            if (!mIsInited) {
                Log.setLogger(HummerLog.instance());
                HummerLog.instance().enableConsoleLogger(false);
                long ret = HummerNative.init(appId, "");
                if (ret < 0L) {
                    Log.e(TAG, "createRtcEngine | init failed");
                    return;
                }
                mIsInited = true;
            }
        }
    }

    public void reportReturnCode(String function, long rtt, int code) {
        HummerNative.reportReturnCode(function, rtt, code);
    }

    @Override
    public void handleNotify(int type, byte[] data) {
        Log.i(TAG, "handleNotify | type: " + type);
        try {
            switch (type) {
                case 100: {
                    this.handleHummerStateChanged(data);
                    break;
                }
                case 101: {
                    NotifyHummerKicked base = new NotifyHummerKicked();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerKicked notify = (HummerNotification.HummerKicked)base.get();
                    this.handleHummerKicked(notify.getCode(), notify.getDescription());
                    break;
                }
                case 102: {
                    NotifyHummerKicked base = new NotifyHummerKicked();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerKicked notify = (HummerNotification.HummerKicked)base.get();
                    this.handleTokenExpired(new Error(notify.getCode(), notify.getDescription()));
                    break;
                }
                case 103: {
                    if (mLoginCompletions.isEmpty()) break;
                    NotifyHummerLogin base = new NotifyHummerLogin();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerLogin notify = (HummerNotification.HummerLogin)base.get();
                    RequestId requestId = new RequestId(notify.getRequestId());
                    HMRCompletion completion = mLoginCompletions.remove(requestId);
                    HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
                    break;
                }
                case 104: {
                    this.handleRefreshTokenCallback(data);
                    break;
                }
                case 105: {
                    if (mLogoutCompletions.isEmpty()) break;
                    NotifyHummerLogout base = new NotifyHummerLogout();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerLogout notify = (HummerNotification.HummerLogout)base.get();
                    RequestId requestId = new RequestId(notify.getRequestId());
                    HMRCompletion completion = mLogoutCompletions.remove(requestId);
                    HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
                    break;
                }
                case 200: {
                    NotifyReportInit base = new NotifyReportInit();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.ReportInit notify = (HummerNotification.ReportInit)base.get();
                    HiidoReporter.init(notify.getAppKey(), notify.getVersion(), notify.getFrom());
                    break;
                }
                case 201: {
                    NotifyReportArea base = new NotifyReportArea();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.ReportArea notify = (HummerNotification.ReportArea)base.get();
                    HiidoReporter.setRegion(HiidoReporter.Region.values()[notify.getArea()]);
                    break;
                }
                case 202: {
                    NotifyReportMetricsReturnCode base = new NotifyReportMetricsReturnCode();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.ReportMetricsReturnCode notify = (HummerNotification.ReportMetricsReturnCode)base.get();
                    HiidoReporter.reportReturnCode(notify.getSCode(), notify.getUri(), notify.getTimeConsumption(), notify.getCode());
                    break;
                }
                case 203: {
                    NotifyReport base = new NotifyReport();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.Report notify = (HummerNotification.Report)base.get();
                    HiidoReporter.reportAct(notify.getType(), null, null, notify.getData());
                    break;
                }
                case 106: {
                    this.handleRefreshToken1Callback(data);
                    break;
                }
                case 107: {
                    this.handleTokenWillExpired(data);
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "handleNotify | type: " + type + ", err: " + e.getMessage());
        }
    }

    private void notifyPreviousTokenExpired(final Error error) {
        Log.i(TAG, "notifyPreviousTokenExpired, errCode: " + error.code);
        if (error.code == ErrorEnum.EXPIRED_TOKEN_EXCEPTION.getCode()) {
            HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void visit() {
                    Set set = mTokenInvalidListeners;
                    synchronized (set) {
                        for (HMR.TokenInvalidListener l : mTokenInvalidListeners) {
                            l.onHummerTokenInvalid(HMR.TokenInvalidCode.EXPIRED, error.desc);
                            l.onHummerPreviousTokenExpired();
                        }
                    }
                }
            });
        }
    }

    private void handleHummerStateChanged(byte[] data) {
        NotifyHummerStateChanged base = new NotifyHummerStateChanged();
        base.unmarshall(data);
        final HummerNotification.HummerStateChanged notify = (HummerNotification.HummerStateChanged)base.get();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Set set = mHummerListeners;
                synchronized (set) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        HMR.ConnectionState oldState = HMR.ConnectionState.values()[notify.getOldState()];
                        HMR.ConnectionState newState = HMR.ConnectionState.values()[notify.getNewState()];
                        l.onConnectionStateChanged(oldState, newState, notify.getReason());
                    }
                }
            }
        });
    }

    private void handleTokenExpired(Error err) {
        if (mTokenProvider != null) {
            byte[] token = mTokenProvider.getToken(HMR.getMe().getId());
            if (token != null && token.length > 0) {
                HummerEngine.refreshToken1(new String(token), new HMR.Completion(){

                    @Override
                    public void onSuccess() {
                        Log.i(HummerEngine.TAG, "refreshToken1 succeed by tokenProvider!");
                    }

                    @Override
                    public void onFailed(Error err) {
                        HummerEngine.this.notifyPreviousTokenExpired(err);
                    }
                });
            } else {
                Log.e(TAG, "getToken is invalid by tokenProvider!");
                this.notifyPreviousTokenExpired(err);
            }
        } else {
            this.notifyPreviousTokenExpired(err);
        }
    }

    private void handleRefreshTokenCallback(byte[] data) {
        if (!mRefreshTokenCompletions.isEmpty()) {
            NotifyHummerRefreshToken base = new NotifyHummerRefreshToken();
            ((Marshallable)base).unmarshall(data);
            HummerNotification.HummerRefreshToken notify = (HummerNotification.HummerRefreshToken)base.get();
            RequestId requestId = new RequestId(notify.getRequestId());
            HMRCompletion completion = mRefreshTokenCompletions.remove(requestId);
            HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
        }
    }

    private void handleRefreshToken1Callback(byte[] data) {
        if (!mRefreshTokenCompletions.isEmpty()) {
            NotifyHummerRefreshToken base = new NotifyHummerRefreshToken();
            ((Marshallable)base).unmarshall(data);
            HummerNotification.HummerRefreshToken notify = (HummerNotification.HummerRefreshToken)base.get();
            RequestId requestId = new RequestId(notify.getRequestId());
            HMRCompletion completion = mRefreshTokenCompletions.remove(requestId);
            HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
        }
    }

    private void handleTokenWillExpired(byte[] data) {
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Set set = mHummerListeners;
                synchronized (set) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        l.onHummerTokenWillExpired();
                    }
                }
            }
        });
    }

    public void handleLogCallback(final byte[] data) {
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            @Override
            public void visit() {
                NotifyHummerLogCallback base = new NotifyHummerLogCallback();
                ((Marshallable)base).unmarshall(data);
                HummerNotification.HummerLogCallback notify = (HummerNotification.HummerLogCallback)base.get();
                HummerLog.instance().logCallback(notify.getLevel(), notify.getLog());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHummerKicked(final int code, final String reason) {
        Set<KickOutHandler> set = mKickOutHandler;
        synchronized (set) {
            for (KickOutHandler l : mKickOutHandler) {
                l.onHummerKickedResult(new Error(code, reason));
            }
        }
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Set set = mHummerListeners;
                synchronized (set) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        l.onForceoutOffline(code, reason);
                    }
                }
            }
        });
    }

    public static long login(long uid, String region, String token, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion c = new HMRCompletion(requestId, completion);
        mLoginCompletions.put(requestId, c);
        return HummerNative.login(requestId.getId(), uid, region, token);
    }

    public static long logout(HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion c = new HMRCompletion(requestId, completion);
        mLogoutCompletions.put(requestId, c);
        return HummerNative.logout(requestId.getId());
    }

    public static String getSdkVersion() {
        return HummerNative.getSdkVersion();
    }

    public static HMR.ConnectionState getConnectionState() {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        int state = HummerNative.getState(requestId.getId());
        return HMR.ConnectionState.values()[state];
    }

    public static long refreshToken(String token, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        if (completion != null) {
            HMRCompletion c = new HMRCompletion(requestId, completion);
            mRefreshTokenCompletions.put(requestId, c);
        }
        return HummerNative.refreshToken(requestId.getId(), token);
    }

    public static long refreshToken1(String token, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        if (completion != null) {
            HMRCompletion c = new HMRCompletion(requestId, completion);
            mRefreshTokenCompletions.put(requestId, c);
        }
        return HummerNative.refreshToken1(requestId.getId(), token);
    }

    public static void setTokenProvider(TokenProvider provider) {
        mTokenProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTokenInvalidListener(HMR.TokenInvalidListener listener) {
        if (listener != null) {
            Set<HMR.TokenInvalidListener> set = mTokenInvalidListeners;
            synchronized (set) {
                mTokenInvalidListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTokenInvalidListener(HMR.TokenInvalidListener listener) {
        if (listener != null) {
            Set<HMR.TokenInvalidListener> set = mTokenInvalidListeners;
            synchronized (set) {
                mTokenInvalidListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHummerListener(HMR.HummerListener listener) {
        if (listener != null) {
            Set<HMR.HummerListener> set = mHummerListeners;
            synchronized (set) {
                mHummerListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHummerListener(HMR.HummerListener listener) {
        if (listener != null) {
            Set<HMR.HummerListener> set = mHummerListeners;
            synchronized (set) {
                mHummerListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKickOutHandler(KickOutHandler handler) {
        if (handler != null) {
            Set<KickOutHandler> set = mKickOutHandler;
            synchronized (set) {
                mKickOutHandler.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeKickOutHandler(KickOutHandler handler) {
        if (handler != null) {
            Set<KickOutHandler> set = mKickOutHandler;
            synchronized (set) {
                mKickOutHandler.remove(handler);
            }
        }
    }

    public static interface KickOutHandler {
        public void onHummerKickedResult(Error var1);
    }

    private class NotifyReport
    extends NotifyBase {
        private NotifyReport() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.Report(this.popString16UTF8(), this.popMap(String.class, String.class));
        }
    }

    private class NotifyReportMetricsReturnCode
    extends NotifyBase {
        private NotifyReportMetricsReturnCode() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.ReportMetricsReturnCode(this.popInt(), this.popString16UTF8(), this.popInt64(), this.popString16UTF8());
        }
    }

    private class NotifyReportArea
    extends NotifyBase {
        private NotifyReportArea() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.ReportArea(this.popInt());
        }
    }

    private class NotifyReportInit
    extends NotifyBase {
        private NotifyReportInit() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.ReportInit(this.popString16UTF8(), this.popString16UTF8(), this.popString16UTF8());
        }
    }

    private class NotifyHummerLogCallback
    extends NotifyBase {
        private NotifyHummerLogCallback() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerLogCallback(this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerLogout
    extends NotifyBase {
        private NotifyHummerLogout() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerLogout(this.popInt64(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerRefreshToken
    extends NotifyBase {
        private NotifyHummerRefreshToken() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerRefreshToken(this.popInt64(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerLogin
    extends NotifyBase {
        private NotifyHummerLogin() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerLogin(this.popInt64(), this.popInt64(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerKicked
    extends NotifyBase {
        private NotifyHummerKicked() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerKicked(this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerStateChanged
    extends NotifyBase {
        private NotifyHummerStateChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerStateChanged(this.popInt(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyBase
    extends Marshallable {
        Object notification;

        private NotifyBase() {
        }

        public Object get() {
            return this.notification;
        }
    }
}

