/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.DispatchQueue;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRCompletionArg;

public class HummerDispatch {
    public static void runOutAction(final RunOutActionVisitor visitor) {
        DispatchQueue.main.async(new Runnable(){

            @Override
            public void run() {
                visitor.visit();
            }
        });
    }

    public static void dispatchCompletion(HMRCompletion completion, int code, String desc) {
        if (completion != null) {
            Error error = new Error(code, desc);
            if (code == ErrorEnum.OK.getCode()) {
                CompletionUtils.dispatchSuccess(completion);
            } else {
                CompletionUtils.dispatchFailure(completion, error);
            }
        }
    }

    public static <T> void dispatchCompletion(HMRCompletionArg<T> completion, T result, int code, String desc) {
        if (completion != null) {
            Error error = new Error(code, desc);
            if (code == ErrorEnum.OK.getCode()) {
                CompletionUtils.dispatchSuccess(completion, result);
            } else {
                CompletionUtils.dispatchFailure(completion, error);
            }
        }
    }

    public static interface RunOutActionVisitor {
        public void visit();
    }
}

