/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerDispatch;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im._internals.bridge.marshall.Marshallable;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.ChatService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChatServiceImpl
implements ChatService,
ServiceProvider.Service,
HummerNative.NotificationListener {
    public static final String CHAT_ROOM_SENDER_PREFIX = "user_";
    public static final String CHAT_ROOM_RECEIVER_PREFIX = "chatroom_";
    public static final String CHAT_ROOM_USER_RECEIVER_PREFIX = "chatroom_/user_";
    public static final String MSG_TYPE_CHAT_ROOM_SIGNAL = "hmr_chatRoom_signal/";
    public static final String MSG_TYPE_CHAT_ROOM_TEXT = "hmr_text/";
    private static final String TAG = "ChatServiceImpl";
    private final Map<String, HashSet<ChatService.MessageListener>> mMessageListeners = new HashMap<String, HashSet<ChatService.MessageListener>>();
    private final Map<String, HashSet<ChatService.StateListener>> mStateListeners = new HashMap<String, HashSet<ChatService.StateListener>>();
    private static final String DEFAULT_STATE_LISTENER_KEY = "default_state_listener_key";
    private static final String DEFAULT_MESSAGE_LISTENER_KEY = "default_message_listener_key";
    private static final Map<RequestId, HMRCompletion> mSendMessageCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static List<SendingExtension> sendingExtensions = new ArrayList<SendingExtension>();

    public static void registerSendingExtension(SendingExtension ext) {
        sendingExtensions.add(ext);
    }

    private static MessagePacket makeSendMessage(Message message) {
        for (SendingExtension ext : sendingExtensions) {
            MessagePacket messageContent = ext.makeMessagePacket(message);
            if (messageContent == null) continue;
            return messageContent;
        }
        return null;
    }

    private static boolean completionMessage(Message message, int msgType, long userId, long roomId, String data) {
        for (SendingExtension ext : sendingExtensions) {
            if (!ext.parseMessage(message, msgType, userId, roomId, data)) continue;
            return true;
        }
        return false;
    }

    private String makeChatRoomUser(long uid) {
        return CHAT_ROOM_USER_RECEIVER_PREFIX + uid;
    }

    private String makeChatRoom(long roomId) {
        return CHAT_ROOM_RECEIVER_PREFIX + roomId;
    }

    private long ExtractUserId(String userId) {
        return this.extractUserPrefix(userId, CHAT_ROOM_SENDER_PREFIX);
    }

    private long ExtractChatRoomId(String userId) {
        return this.extractUserPrefix(userId, CHAT_ROOM_RECEIVER_PREFIX);
    }

    private long extractChatRoomUserId(String userId) {
        return this.extractUserPrefix(userId, CHAT_ROOM_USER_RECEIVER_PREFIX);
    }

    private long extractUserPrefix(String userId, String prefix) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return 0L;
        }
        String idStr = userId.replace(prefix, "");
        long id = 0L;
        try {
            id = Long.valueOf(idStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id;
    }

    @Override
    public void handleNotify(final int type, byte[] data) {
        Log.i(TAG, "handleNotify | type: " + type);
        try {
            if (type == 301) {
                NotifyOnSendMessage base = new NotifyOnSendMessage();
                ((Marshallable)base).unmarshall(data);
                HummerNotification.OnSendMessage notify = (HummerNotification.OnSendMessage)base.get();
                RequestId requestId = new RequestId(notify.getRequestId());
                HMRCompletion completion = mSendMessageCompletions.remove(requestId);
                HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
            } else if (type >= 302 && type <= 306) {
                NotifyOnMessage base = new NotifyOnMessage();
                ((Marshallable)base).unmarshall(data);
                final HummerNotification.OnMessage notify = (HummerNotification.OnMessage)base.get();
                boolean result = ChatServiceImpl.completionMessage(notify.getMessage(), notify.getMsgType(), notify.getUserId(), notify.getRoomId(), notify.getData());
                if (result) {
                    final Message message = notify.getMessage();
                    HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void visit() {
                            if (type == 306) {
                                Map map = ChatServiceImpl.this.mStateListeners;
                                synchronized (map) {
                                    HashSet fullListeners;
                                    HashSet listeners = (HashSet)ChatServiceImpl.this.mStateListeners.get(message.getUuid());
                                    if (listeners != null) {
                                        HashSet hashLis = (HashSet)listeners.clone();
                                        for (Object l : hashLis) {
                                            l.onUpdateMessageState(message, message.getState());
                                        }
                                    }
                                    if ((fullListeners = (HashSet)ChatServiceImpl.this.mStateListeners.get(ChatServiceImpl.DEFAULT_STATE_LISTENER_KEY)) != null) {
                                        HashSet hashFullLis = (HashSet)fullListeners.clone();
                                        for (ChatService.StateListener l : hashFullLis) {
                                            l.onUpdateMessageState(message, message.getState());
                                        }
                                    }
                                }
                            }
                            Map map = ChatServiceImpl.this.mMessageListeners;
                            synchronized (map) {
                                String key = String.valueOf(message.getTarget() == null ? "" : Long.valueOf(message.getTarget().getId()));
                                HashSet listeners = (HashSet)ChatServiceImpl.this.mMessageListeners.get(key);
                                HashSet hashLis = listeners == null ? new HashSet() : (HashSet)listeners.clone();
                                HashSet fullListeners = (HashSet)ChatServiceImpl.this.mMessageListeners.get(ChatServiceImpl.DEFAULT_MESSAGE_LISTENER_KEY);
                                if (fullListeners != null) {
                                    hashLis.addAll((HashSet)fullListeners.clone());
                                }
                                for (ChatService.MessageListener listener : hashLis) {
                                    if (type == 302) {
                                        listener.beforeSendingMessage(notify.getMessage());
                                        continue;
                                    }
                                    if (type == 303) {
                                        listener.afterSendingMessage(notify.getMessage());
                                        continue;
                                    }
                                    if (type == 304) {
                                        listener.beforeReceivingMessage(notify.getMessage());
                                        continue;
                                    }
                                    if (type != 305) continue;
                                    listener.afterReceivingMessage(notify.getMessage());
                                }
                            }
                        }
                    });
                } else {
                    Log.e(TAG, "handleNotify | completionMessage failed!");
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "handleNotify | type: " + type + ", err: " + e.getMessage());
        }
    }

    @Override
    public void initService() {
        HummerNative.registerNotificationListener(this);
    }

    @Override
    public void send(@NonNull Message message, final @Nullable HMR.Completion completion) {
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (message == null) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.INVALID_PARAMETER, "message cannot be null"));
            return;
        }
        HMR.Completion completionWrap = new HMR.Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRSendMessage", now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                HMRContext.reportReturnCode("HMRSendMessage", now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        hmrCompletion = new HMRCompletion(requestId, completionWrap);
        mSendMessageCompletions.put(requestId, hmrCompletion);
        MessagePacket packet = ChatServiceImpl.makeSendMessage(message);
        HummerNative.sendMessage(requestId.getId(), packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(@Nullable Identifiable target, @NonNull ChatService.MessageListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.MessageListener>> map = this.mMessageListeners;
            synchronized (map) {
                HashSet<ChatService.MessageListener> listeners;
                String lisKey = DEFAULT_MESSAGE_LISTENER_KEY;
                if (target != null) {
                    lisKey = String.valueOf(target.getId());
                }
                if ((listeners = this.mMessageListeners.get(lisKey)) == null) {
                    listeners = new HashSet();
                    this.mMessageListeners.put(lisKey, listeners);
                }
                listeners.add(listener);
            }
        }
        HMRContext.reportReturnCode("HMRAddMessageListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(@Nullable Identifiable target, @NonNull ChatService.MessageListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.MessageListener>> map = this.mMessageListeners;
            synchronized (map) {
                HashSet<ChatService.MessageListener> listeners;
                String lisKey = DEFAULT_MESSAGE_LISTENER_KEY;
                if (target != null) {
                    lisKey = String.valueOf(target.getId());
                }
                if ((listeners = this.mMessageListeners.get(lisKey)) != null) {
                    listeners.remove(listener);
                }
            }
        }
        HMRContext.reportReturnCode("HMRRemoveMessageListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(@Nullable Message message, @NonNull ChatService.StateListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.StateListener>> map = this.mStateListeners;
            synchronized (map) {
                HashSet<ChatService.StateListener> listeners;
                String lisKey = DEFAULT_STATE_LISTENER_KEY;
                if (message != null) {
                    lisKey = message.getUuid();
                }
                if ((listeners = this.mStateListeners.get(lisKey)) == null) {
                    listeners = new HashSet();
                    this.mStateListeners.put(lisKey, listeners);
                }
                listeners.add(listener);
            }
        }
        HMRContext.reportReturnCode("HMRAddMessageStateListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(@Nullable Message message, @NonNull ChatService.StateListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.StateListener>> map = this.mStateListeners;
            synchronized (map) {
                HashSet<ChatService.StateListener> listeners;
                String lisKey = DEFAULT_STATE_LISTENER_KEY;
                if (message != null) {
                    lisKey = message.getUuid();
                }
                if ((listeners = this.mStateListeners.get(lisKey)) != null) {
                    listeners.remove(listener);
                }
            }
        }
        HMRContext.reportReturnCode("HMRRemoveMessageStateListener", HMRContext.getCurrentTime());
    }

    private class NotifyOnSendMessage
    extends NotifyBase {
        private NotifyOnSendMessage() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            int code = this.popInt();
            String desc = this.popString16UTF8();
            int stateType = this.popInt();
            int stateCode = this.popInt();
            String stateDesc = this.popString16UTF8();
            String uuid = this.popString16UTF8();
            long timestamp = this.popInt64();
            String sender = this.popString16UTF8();
            String receiver = this.popString16UTF8();
            String contentData = this.popString32("utf-8");
            String contentReserved = this.popString16();
            String extra = this.popString16();
            Message message = new Message();
            this.notification = new HummerNotification.OnSendMessage(requestId, code, desc, message);
        }
    }

    private class NotifyOnMessage
    extends NotifyBase {
        private NotifyOnMessage() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int stateType = this.popInt();
            int stateCode = this.popInt();
            String stateDesc = this.popString16UTF8();
            String uuid = this.popString16UTF8();
            long timestamp = this.popInt64();
            String sender = this.popString16UTF8();
            String receiver = this.popString16UTF8();
            String contentData = this.popString32("utf-8");
            String contentReserved = this.popString16();
            String extra = this.popString16UTF8();
            Map<String, String> kv = this.popMap(String.class, String.class);
            int msgType = this.popInt();
            long userId = this.popInt64();
            long roomId = this.popInt2Long();
            Message message = new Message();
            message.setState(Message.buildSate(stateType, stateCode, stateDesc));
            message.setSender(new User(ChatServiceImpl.this.ExtractUserId(sender)));
            message.setUuid(uuid);
            message.setTimestamp(timestamp);
            message.setAppExtra(extra);
            message.setKvExtra(kv);
            this.notification = new HummerNotification.OnMessage(message, msgType, userId, roomId, contentData);
        }
    }

    private class NotifyBase
    extends Marshallable {
        Object notification;

        private NotifyBase() {
        }

        public Object get() {
            return this.notification;
        }
    }

    public static interface SendingExtension {
        public MessagePacket makeMessagePacket(Message var1);

        public boolean parseMessage(Message var1, int var2, long var3, long var5, String var7);
    }

    public static class MessagePacket {
        public static final int MSG_TYPE_TEXT = 10;
        public static final int MSG_TYPE_BROADCAST = 20;
        public static final int MSG_TYPE_UNICAST = 30;
        private long userId;
        private long roomId;
        private int msgType;
        private String data;
        private String extra;
        private Map<String, String> kvExtra;

        public MessagePacket() {
        }

        public MessagePacket(long userId, long roomId, int msgType, String data, String extra, Map<String, String> kvExtra) {
            this.userId = userId;
            this.roomId = roomId;
            this.data = data;
            this.msgType = msgType;
            this.extra = extra;
            this.kvExtra = kvExtra;
        }

        public long getUserId() {
            return this.userId;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }

        public long getRoomId() {
            return this.roomId;
        }

        public void setRoomId(long roomId) {
            this.roomId = roomId;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public void setMsgType(int msgType) {
            this.msgType = msgType;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public Map<String, String> getKvExtra() {
            return this.kvExtra;
        }

        public void setKvExtra(Map<String, String> kvExtra) {
            this.kvExtra = kvExtra;
        }
    }
}

