/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import androidx.annotation.NonNull;
import com.hummer.im._internals.bridge.helper.HummerDispatch;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im._internals.bridge.marshall.Marshallable;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.RequestId;
import com.hummer.im.service.ChannelStateService;
import java.util.HashSet;
import java.util.Set;

public class ChannelStateServiceImpl
implements ChannelStateService,
ServiceProvider.Service,
HummerNative.NotificationListener {
    private static final String TAG = "ChannelStateServiceImpl";
    private static final Set<ChannelStateService.ChannelStateListener> mChannelStateListener = new HashSet<ChannelStateService.ChannelStateListener>();

    @Override
    public void handleNotify(int type, byte[] data) {
        Log.i(TAG, "handleNotify | type: " + type);
        if (type == 100) {
            this.handleHummerStateChanged(data);
        }
    }

    @Override
    public void initService() {
        HummerNative.registerNotificationListener(this);
    }

    @Override
    public ChannelStateService.ChannelState getState() {
        long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        int state = HummerNative.getState(requestId.getId());
        ChannelStateService.ChannelState channelState = ChannelStateServiceImpl.getConvertState(state);
        HMRContext.reportReturnCode("HMRGetChannelState", now);
        return channelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannelStateListener(@NonNull ChannelStateService.ChannelStateListener listener) {
        HMRContext.reportReturnCode("HMRAddChannelStateListener", HMRContext.getCurrentTime());
        if (listener != null) {
            Set<ChannelStateService.ChannelStateListener> set = mChannelStateListener;
            synchronized (set) {
                mChannelStateListener.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChannelStateListener(@NonNull ChannelStateService.ChannelStateListener listener) {
        HMRContext.reportReturnCode("HMRRemoveChannelStateListener", HMRContext.getCurrentTime());
        if (listener != null) {
            Set<ChannelStateService.ChannelStateListener> set = mChannelStateListener;
            synchronized (set) {
                mChannelStateListener.remove(listener);
            }
        }
    }

    private void handleHummerStateChanged(byte[] data) {
        NotifyHummerStateChanged base = new NotifyHummerStateChanged();
        base.unmarshall(data);
        final HummerNotification.HummerStateChanged notify = (HummerNotification.HummerStateChanged)base.get();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Set set = mChannelStateListener;
                synchronized (set) {
                    for (ChannelStateService.ChannelStateListener l : mChannelStateListener) {
                        ChannelStateService.ChannelState oldState = ChannelStateServiceImpl.getConvertState(notify.getOldState());
                        ChannelStateService.ChannelState newState = ChannelStateServiceImpl.getConvertState(notify.getNewState());
                        l.onUpdateChannelState(oldState, newState);
                    }
                }
            }
        });
    }

    private static ChannelStateService.ChannelState getConvertState(int state) {
        switch (state) {
            case 0: 
            case 1: {
                return ChannelStateService.ChannelState.Disconnected;
            }
            case 2: 
            case 3: {
                return ChannelStateService.ChannelState.Connecting;
            }
            case 4: {
                return ChannelStateService.ChannelState.Connected;
            }
        }
        return ChannelStateService.ChannelState.Disconnected;
    }

    private class NotifyHummerStateChanged
    extends Marshallable {
        private Object notification;

        private NotifyHummerStateChanged() {
        }

        public Object get() {
            return this.notification;
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerStateChanged(this.popInt(), this.popInt(), this.popString16UTF8());
        }
    }
}

