/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.bridge.helper.HummerEngine;
import com.hummer.im._internals.log.HummerLog;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.DispatchQueue;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.auth.TokenProvider;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;

public final class HMR {
    private static final HummerEngine.KickOutHandler KICK_OUT_HANDLER = new HummerEngine.KickOutHandler(){

        @Override
        public void onHummerKickedResult(Error error) {
            HMR.setHummerState(State.Closed);
        }
    };
    private static final String TAG = "HMR";
    private static State state = State.Unavailable;
    private static TokenProvider mTokenProvider = null;
    private static final Set<StateListener> mStateListeners = new HashSet<StateListener>();
    private static User me = new User(0L);

    private HMR() {
    }

    private static boolean isInitialized() {
        return HMRContext.appId != null || state != State.Unavailable;
    }

    @Deprecated
    public static void init(@NonNull Context appContext, long appId, @Nullable TokenProvider provider) {
        long now = HMRContext.getCurrentTime();
        if (HMR.isInitialized()) {
            Log.e(TAG, Trace.method("init").info("Hummer already been initialized!", ""));
            return;
        }
        HMRContext.appId = appId;
        HMRContext.appContext = new WeakReference<Context>(appContext.getApplicationContext());
        HummerEngine.getInstance().init(appId);
        mTokenProvider = provider;
        HummerEngine.setTokenProvider(provider);
        HMR.setHummerState(State.Closed);
        HMRContext.reportReturnCode("HMRInitWithTokenProvider", now);
    }

    public static void init(@NonNull Context appContext, long appId) {
        long now = HMRContext.getCurrentTime();
        if (HMR.isInitialized()) {
            Log.e(TAG, Trace.method("init").info("Hummer already been initialized!", ""));
            return;
        }
        HMRContext.appId = appId;
        HMRContext.appContext = new WeakReference<Context>(appContext.getApplicationContext());
        HummerEngine.getInstance().init(appId);
        HMR.setHummerState(State.Closed);
        HMRContext.reportReturnCode("HMRInit", now);
    }

    @Deprecated
    public static void open(long uid, @NonNull String region, @Nullable Set<String> tagSet, @Nullable Completion completion) {
        byte[] bytes;
        String token = "";
        if (mTokenProvider != null && (bytes = mTokenProvider.getToken(uid)) != null && bytes.length > 0) {
            token = new String(bytes);
        }
        HMR.doOpen(uid, region, token, completion, "HMROpen");
    }

    @Deprecated
    public static void open(long uid, @NonNull String region, @Nullable Set<String> tagSet, @Nullable TokenProvider provider, @Nullable Completion completion) {
        byte[] bytes;
        HummerEngine.setTokenProvider(provider);
        String token = "";
        if (provider != null && (bytes = provider.getToken(uid)) != null && bytes.length > 0) {
            token = new String(bytes);
        }
        HMR.doOpen(uid, region, token, completion, "HMROpenWithTokenProvider");
    }

    public static void open(long uid, @NonNull String region, @Nullable Set<String> tagSet, @NonNull String token, @Nullable Completion completion) {
        HMR.doOpen(uid, region, token, completion, "HMROpenWithToken");
    }

    private static void doOpen(long uid, String region, String token, final Completion completion, final String funcName) {
        final long now = HMRContext.getCurrentTime();
        Log.i(TAG, Trace.method("open").msg("open sdk").info("uid", uid));
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            return;
        }
        if (uid < 0L) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.INVALID_PARAMETER, "uid cannot be negative"));
            return;
        }
        HummerEngine.addKickOutHandler(KICK_OUT_HANDLER);
        HMR.setHummerState(State.Opening);
        me = new User(uid);
        HMRContext.region = region;
        Completion completionWrap = new Completion(){

            @Override
            public void onSuccess() {
                HMR.setHummerState(State.Opened);
                HMRContext.reportReturnCode(funcName, now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                me = null;
                HMRContext.region = null;
                HMR.setHummerState(State.Closed);
                HMRContext.reportReturnCode(funcName, now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        HummerEngine.login(uid, region, token, completionWrap);
    }

    public static void close(@Nullable Completion completion) {
        long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            HMRContext.reportReturnCode("HMRClose", now, ErrorEnum.UNINITIALIZED_EXCEPTION.getCode());
            return;
        }
        HMR.setHummerState(State.Closing);
        me = null;
        HMRContext.region = null;
        HummerEngine.removeKickOutHandler(KICK_OUT_HANDLER);
        HummerEngine.logout(completion);
        HMR.setHummerState(State.Closed);
        HMRContext.reportReturnCode("HMRClose", now);
    }

    public static <Service> Service getService(@NonNull Class<Service> serviceClass) {
        return ServiceProvider.get(serviceClass);
    }

    public static State getState() {
        HMRContext.reportReturnCode("HMRGetState", HMRContext.getCurrentTime());
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStateListener(@NonNull StateListener listener) {
        HMRContext.reportReturnCode("HMRAddStateListener", HMRContext.getCurrentTime());
        if (listener != null) {
            Set<StateListener> set = mStateListeners;
            synchronized (set) {
                mStateListeners.add(listener);
            }
            HMR.setHummerState(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStateListener(@NonNull StateListener listener) {
        HMRContext.reportReturnCode("HMRRemoveStateListener", HMRContext.getCurrentTime());
        if (listener != null) {
            Set<StateListener> set = mStateListeners;
            synchronized (set) {
                mStateListeners.remove(listener);
            }
        }
    }

    private static void setHummerState(@Nullable State state) {
        State fromState = HMR.state;
        if (state != null) {
            HMR.state = state;
        }
        HMR.notifyUpdateHummerState(fromState, HMR.state);
    }

    private static void notifyUpdateHummerState(final State fromState, final State toState) {
        DispatchQueue.main.sync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = mStateListeners;
                synchronized (set) {
                    for (StateListener l : mStateListeners) {
                        l.onUpdateHummerState(fromState, toState);
                    }
                }
            }
        });
    }

    public static void addTokenInvalidListener(@NonNull TokenInvalidListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.addTokenInvalidListener(listener);
        HMRContext.reportReturnCode("HMRAddTokenInvalidListener", now);
    }

    public static void removeTokenInvalidListener(@NonNull TokenInvalidListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.removeTokenInvalidListener(listener);
        HMRContext.reportReturnCode("HMRRemoveTokenInvalidListener", now);
    }

    public static void addHummerListener(@NonNull HummerListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.addHummerListener(listener);
        HMRContext.reportReturnCode("HMRAddHummerListener", now);
    }

    public static void removeHummerListener(@NonNull HummerListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.removeHummerListener(listener);
        HMRContext.reportReturnCode("HMRRemoveHummerListener", now);
    }

    public static ConnectionState getConnectionState() {
        long now = HMRContext.getCurrentTime();
        ConnectionState state = HummerEngine.getConnectionState();
        HMRContext.reportReturnCode("HMRGetConnectionState", now);
        return state;
    }

    public static String getVersion() {
        long now = HMRContext.getCurrentTime();
        String version = HummerEngine.getSdkVersion();
        HMRContext.reportReturnCode("HMRGetVersion", now);
        return version;
    }

    public static User getMe() {
        return me;
    }

    public static boolean isMe(Identifiable identity) {
        return Identifiable.equals(me, identity);
    }

    @Deprecated
    public static void refreshToken(@NonNull String token) {
        final long now = HMRContext.getCurrentTime();
        Completion completion = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshToken", now);
            }

            @Override
            public void onFailed(Error err) {
                HMR.setHummerState(State.Closed);
                HMRContext.reportReturnCode("HMRRefreshToken", now, err);
            }
        };
        HummerEngine.refreshToken(token, completion);
    }

    @Deprecated
    public static void refreshToken(@NonNull String token, final @Nullable Completion completion) {
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            return;
        }
        Completion completionWrap = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshTokenWithCompletion", now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                HMR.setHummerState(State.Closed);
                HMRContext.reportReturnCode("HMRRefreshTokenWithCompletion", now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        HummerEngine.refreshToken(token, completionWrap);
    }

    public static void refreshToken1(@NonNull String token, final @Nullable Completion completion) {
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            return;
        }
        Completion completionWrap = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshToken1", now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                HMRContext.reportReturnCode("HMRRefreshToken1", now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        HummerEngine.refreshToken1(token, completionWrap);
    }

    public static boolean setLoggerFilePath(@NonNull String loggerPath) {
        long now = HMRContext.getCurrentTime();
        if (TextUtils.isEmpty((CharSequence)loggerPath)) {
            Log.e(TAG, Trace.method("setLoggerFilePath").msg("path must be not null").info("path", loggerPath));
            HMRContext.reportReturnCode("HMRSetLoggerFilePath", now, ErrorEnum.INVALID_PARAMETER.getCode());
            return false;
        }
        Log.i(TAG, "setLoggerFilePath: " + loggerPath);
        HummerLog.instance().setLogFilePath(loggerPath);
        HMRContext.reportReturnCode("HMRSetLoggerFilePath", now);
        return true;
    }

    public static boolean setLogLevel(HMRLogLevel logLevel) {
        long now = HMRContext.getCurrentTime();
        if (logLevel == null) {
            Log.e(TAG, Trace.method("setLogLevel").msg("level must be not null"));
            HMRContext.reportReturnCode("HMRSetLogLevel", now, ErrorEnum.INVALID_PARAMETER.getCode());
            return false;
        }
        Log.i(TAG, Trace.method("setLogLevel").info("level", logLevel.getLevel()));
        HummerLog.instance().setLogLevel(logLevel.getLevel());
        HMRContext.reportReturnCode("HMRSetLogLevel", now);
        return true;
    }

    public static boolean uploadLogsManually(String remark) {
        long now = HMRContext.getCurrentTime();
        HummerLog.instance().uploadLog(remark);
        HMRContext.reportReturnCode("HMRUploadLogsManually", now);
        return true;
    }

    public static boolean setLogCallback(HMRLogCallback callback) {
        long now = HMRContext.getCurrentTime();
        HummerLog.instance().setLogCallback(callback);
        HMRContext.reportReturnCode("HMRSetLogCallback", now);
        return true;
    }

    public static interface HMRLogCallback {
        public void onHmrLogWithLevel(HMRLogLevel var1, String var2);
    }

    public static enum HMRLogLevel {
        HMR_LOG_LEVEL_VERBOSE(0),
        HMR_LOG_LEVEL_DEBUG(1),
        HMR_LOG_LEVEL_INFO(2),
        HMR_LOG_LEVEL_WARNING(3),
        HMR_LOG_LEVEL_ERROR(4),
        HMR_LOG_LEVEL_RELEASE(10);

        private int level;

        private HMRLogLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public static HMRLogLevel toLevel(int level) {
            for (HMRLogLevel type : HMRLogLevel.values()) {
                if (type.getLevel() != level) continue;
                return type;
            }
            return HMR_LOG_LEVEL_VERBOSE;
        }
    }

    public static interface CompletionArgs<Argument1, Argument2> {
        public void onSuccess(Argument1 var1, Argument2 var2);

        public void onFailed(Error var1);
    }

    public static interface CompletionArg<Argument> {
        public void onSuccess(Argument var1);

        public void onFailed(Error var1);
    }

    public static interface Completion {
        public void onSuccess();

        public void onFailed(Error var1);
    }

    public static interface HummerListener {
        public void onConnectionStateChanged(ConnectionState var1, ConnectionState var2, String var3);

        public void onHummerTokenWillExpired();

        public void onForceoutOffline(int var1, String var2);
    }

    public static interface TokenInvalidListener {
        @Deprecated
        public void onHummerTokenInvalid(TokenInvalidCode var1, String var2);

        public void onHummerPreviousTokenExpired();
    }

    public static interface StateListener {
        public void onUpdateHummerState(State var1, State var2);
    }

    public static enum TokenInvalidCode {
        EXPIRED(2003);

        private int code;

        private TokenInvalidCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum ConnectionState {
        Unavailable,
        Disconnected,
        Connecting,
        Reconnecting,
        Connected;

    }

    public static enum State {
        Unavailable,
        Opening,
        Opened,
        Closing,
        Closed;

    }
}

