/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.service;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.HMR;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.chat.store.RemovingClauses;
import com.hummer.im.model.id.Identifiable;
import java.util.List;
import java.util.Set;

public interface ChatStoreService {
    public List<Chat> getChats();

    public List<Chat> getChatsByTag(@NonNull String var1);

    public Chat getChat(@NonNull Identifiable var1);

    @Deprecated
    public void createChat(@NonNull Identifiable var1, @NonNull HMR.CompletionArg<Chat> var2);

    public void makeChat(@NonNull Identifiable var1, @NonNull HMR.CompletionArg<Chat> var2);

    public void addChat(@NonNull Chat var1, @Nullable HMR.Completion var2);

    public void removeChat(@NonNull Chat var1, @Nullable HMR.Completion var2);

    public void updateChat(@NonNull Chat var1, @NonNull HMR.Completion var2);

    public void resetUnread(@NonNull Chat var1, @Nullable HMR.Completion var2);

    public void addOrUpdateMessage(@NonNull Chat var1, @NonNull Message var2, @Nullable HMR.Completion var3);

    public void fetchMessages(@NonNull Chat var1, @NonNull FetchingClauses var2, @Nullable HMR.CompletionArg<List<Message>> var3);

    public void fetchMessagesByUuids(@NonNull Chat var1, @NonNull Set<String> var2, @NonNull HMR.CompletionArg<List<Message>> var3);

    public void removeMessages(@NonNull Chat var1, @NonNull RemovingClauses var2, @Nullable HMR.Completion var3);

    public void setPriority(@NonNull Chat var1, int var2, @Nullable HMR.Completion var3);

    public void setTags(@NonNull Chat var1, @NonNull Set<String> var2, @Nullable HMR.Completion var3);

    public void addTags(@NonNull Chat var1, @NonNull Set<String> var2, @Nullable HMR.Completion var3);

    public void removeTags(@NonNull Chat var1, @NonNull Set<String> var2, @Nullable HMR.Completion var3);

    public void setChatFilter(Filter var1);

    public void addChatListener(@NonNull ChatListener var1);

    public void removeChatListener(@NonNull ChatListener var1);

    public void addMessageListener(@Nullable Chat var1, @NonNull MessageListener var2);

    public void removeMessageListener(@Nullable Chat var1, @NonNull MessageListener var2);

    public static interface ChatListener {
        @Deprecated
        public void afterCreatingChat(@NonNull Chat var1);

        public void afterAddChat(@NonNull Chat var1);

        public void beforeRemovingChat(@NonNull Chat var1);

        public void afterUpdateChat(@NonNull Chat var1);

        public void afterUpdateChats(@NonNull List<Chat> var1);
    }

    public static interface MessageListener {
        public void afterAddingMessage(Chat var1, Message var2);

        public void afterUpdateMessage(Chat var1, Message var2);

        public void beforeRemovingMessages(Chat var1, List<Message> var2);

        public void afterClearMessages(Chat var1);
    }

    public static interface Filter {
        public boolean shouldAcceptMessage(Message var1);
    }
}

