/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.states;

import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Delivering;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Init;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.model.chat.states.Revoked;

public final class StateFactory {
    private static final String Init = "Init";
    private static final String Preparing = "Preparing";
    private static final String Delivering = "Delivering";
    private static final String Archived = "Archived";
    private static final String Failed = "Failed";
    private static final String Revoked = "Revoked";

    public static String makeString(Message.State state) {
        String st = null;
        if (state instanceof Init) {
            st = Init;
        } else if (state instanceof Preparing) {
            st = Preparing;
        } else if (state instanceof Delivering) {
            st = Delivering;
        } else if (state instanceof Archived) {
            st = Archived;
        } else if (state instanceof Failed) {
            Failed failed = (Failed)state;
            st = "Failed_" + String.valueOf(failed.error.code) + "_" + String.valueOf(failed.error.desc);
        } else if (state instanceof Revoked) {
            st = Revoked;
        }
        if (st == null) {
            Log.e((String)"MessageState", (Object)Trace.method((String)"makeString").info("st", (Object)st));
        }
        return st;
    }

    public static Message.State makeState(String string) {
        String prefix;
        Init state = null;
        String[] parts = string.split("_");
        switch (prefix = parts[0]) {
            case "Init": {
                state = new Init();
                break;
            }
            case "Preparing": {
                state = new Preparing();
                break;
            }
            case "Delivering": {
                state = new Delivering();
                break;
            }
            case "Archived": {
                state = new Archived();
                break;
            }
            case "Failed": {
                Error error = new Error(Integer.parseInt(parts[1]), parts[2]);
                state = new Failed(error);
                break;
            }
            case "Revoked": {
                state = new Revoked();
                break;
            }
            default: {
                Log.e((String)"MessageState", (Object)Trace.method((String)"makeState").info("\u672a\u652f\u6301\u7684state\u7c7b\u578b:", (Object)prefix));
            }
        }
        if (state == null) {
            Log.e((String)"MessageState", (Object)Trace.method((String)"makeState").info("BUGY! \u672a\u652f\u6301\u7684state\u7c7b\u578b:", (Object)string));
        }
        return state;
    }
}

