/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodecManager<DataType, DataValue, Model> {
    private static final String TAG = "CodecManager";
    private final Map<DataType, Codec<DataType, DataValue, Model>> type2codec = new ConcurrentHashMap<DataType, Codec<DataType, DataValue, Model>>();
    private final Map<Class<? extends Model>, Codec<DataType, DataValue, Model>> clazz2codec = new ConcurrentHashMap<Class<? extends Model>, Codec<DataType, DataValue, Model>>();

    public void register(Codec<DataType, DataValue, Model> codec) {
        DataType key = codec.getDataType();
        this.type2codec.put(key, codec);
        Class<Model> clazz = codec.getModelClass();
        this.clazz2codec.put(clazz, codec);
    }

    public DataType getDataType(Model model) {
        Class<?> clazz = model.getClass();
        Codec<DataType, DataValue, Model> codec = this.clazz2codec.get(clazz);
        if (codec == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"getDataType").msg((Object)"codec is null").info("model", model).info("clazz", clazz).info("clazz2codec", this.clazz2codec));
            return null;
        }
        try {
            return codec.getDataType();
        }
        catch (Throwable t) {
            Log.e((String)TAG, (Object)Trace.method((String)"encode").msg((Object)"Exception").info("model", model).info("clazz", clazz).info("error", (Object)t.getMessage()));
            return null;
        }
    }

    public DataValue encode(Model model) {
        Class<?> clazz = model.getClass();
        Codec<DataType, DataValue, Model> codec = this.clazz2codec.get(clazz);
        if (codec == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"encode").msg((Object)"codec is null").info("model", model).info("clazz", clazz).info("clazz2codec", this.clazz2codec));
            return null;
        }
        try {
            return codec.encode(model);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (Object)Trace.method((String)"encode").msg((Object)"Exception").info("model", model).info("clazz", clazz).info("error", (Object)t.getMessage()));
            return null;
        }
    }

    public Model decode(DataType type, DataValue data) {
        Codec<DataType, DataValue, Model> codec = this.type2codec.get(type);
        if (codec == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"decode").msg((Object)"codec is null").info("type", type).info("data", data).info("type2codec", (Object)this.type2codec.toString()));
            return null;
        }
        try {
            return codec.decode(data);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (Object)Trace.method((String)"decode").msg((Object)"Exception").info("type", type).info("data", data).info("error", (Object)t.getMessage()));
            return null;
        }
    }

    public boolean isNotExistCodec(DataType type) {
        return this.type2codec.get(type) == null;
    }

    public static interface Codec<DataType, DataValue, Model> {
        public DataType getDataType();

        public Class<? extends Model> getModelClass();

        public Model decode(DataValue var1) throws Throwable;

        public DataValue encode(Model var1) throws Throwable;
    }
}

