/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.ChatStoreServiceImpl;
import com.hummer.im._internals.ChatUpgradeService;
import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.states.StateFactory;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.ChatStoreService;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SPChatStoreModuleLoader
implements ServiceProvider.ModuleLoader {
    public void deInitModule() {
    }

    public void initModule() {
        SPChatStoreModuleLoader.registerChatMessageCodecs();
    }

    public Map<Class, ServiceProvider.Service> getServices() {
        return new HashMap<Class, ServiceProvider.Service>(){
            {
                this.put(ChatStoreService.class, new ChatStoreServiceImpl());
                this.put(ChatUpgradeService.class, new ChatUpgradeService());
            }
        };
    }

    private static void registerChatMessageCodecs() {
        BeanMessage.codecs.register(SPChatStoreModuleLoader.generateCodec("hmr_text_message"));
        BeanMessage.codecs.register(SPChatStoreModuleLoader.generateCodec("chat_message"));
        BeanConversation.codecs.register(SPChatStoreModuleLoader.generateLatestMessageCodec());
    }

    private static CodecManager.Codec<String, String, Message> generateLatestMessageCodec() {
        String legacyType = "hmr_text_message";
        String indexText = "text";
        String indexAppExtra = "appExtra";
        String indexPushContent = "pushContent";
        String indexContentType = "contentType";
        String indexContent = "content";
        String indexUUID = "uuid";
        String indexTimestamp = "ts";
        String indexSender = "sender";
        String indexReceiver = "receiver";
        String indexState = "state";
        return new CodecManager.Codec<String, String, Message>(){

            @Override
            public String getDataType() {
                return "chat_latest_message";
            }

            @Override
            public Class<? extends Message> getModelClass() {
                return Message.class;
            }

            @Override
            public String encode(Message message) throws JSONException {
                JSONObject json = new JSONObject();
                json.put("uuid", (Object)message.getUuid());
                json.put("ts", message.getTimestamp());
                json.put("sender", (Object)IDFactory.makeString((Identifiable)message.getSender()));
                json.put("receiver", (Object)IDFactory.makeString((Identifiable)message.getReceiver()));
                json.put("state", (Object)StateFactory.makeString(message.getState()));
                json.put("contentType", (Object)Content.getDataType((Content)message.getContent()));
                json.put("content", (Object)Content.makeString((Content)message.getContent()));
                json.put("appExtra", (Object)(message.getAppExtra() == null ? "" : message.getAppExtra()));
                json.put("pushContent", (Object)PushContent.makeString((PushContent)message.getPushContent()));
                return json.toString();
            }

            @Override
            public Message decode(String content) throws JSONException {
                JSONObject json = new JSONObject(content);
                Message message = new Message();
                message.setUuid(json.getString("uuid"));
                message.setTimestamp(json.getLong("ts"));
                message.setSender(IDFactory.makeId((String)json.getString("sender")));
                message.setReceiver(IDFactory.makeId((String)json.getString("receiver")));
                message.setState(StateFactory.makeState(json.getString("state")));
                if (json.has("appExtra")) {
                    message.setAppExtra(json.getString("appExtra"));
                }
                if (json.has("pushContent")) {
                    message.setPushContent(PushContent.makeContent((String)json.getString("pushContent")));
                }
                if ("hmr_text_message".equals(this.getDataType())) {
                    message.setContent(Content.makeContent((int)0, (String)json.getString("text")));
                } else {
                    int contentType = json.getInt("contentType");
                    message.setContent(Content.makeContent((int)contentType, (String)json.getString("content")));
                }
                return message;
            }
        };
    }

    private static CodecManager.Codec<String, BeanMessage.DBMessageData, Message> generateCodec(final String dataType) {
        String legacyType = "hmr_text_message";
        String indexText = "text";
        String indexContentType = "contentType";
        String indexContent = "content";
        String indexUUID = "uuid";
        String indexTimestamp = "ts";
        String indexSender = "sender";
        String indexReceiver = "receiver";
        String indexState = "state";
        return new CodecManager.Codec<String, BeanMessage.DBMessageData, Message>(){

            @Override
            public String getDataType() {
                return dataType;
            }

            @Override
            public Class<? extends Message> getModelClass() {
                return Message.class;
            }

            @Override
            public BeanMessage.DBMessageData encode(Message chatMessage) throws JSONException {
                JSONObject json = new JSONObject();
                json.put("uuid", (Object)chatMessage.getUuid());
                json.put("ts", chatMessage.getTimestamp());
                json.put("sender", (Object)IDFactory.makeString((Identifiable)chatMessage.getSender()));
                json.put("receiver", (Object)IDFactory.makeString((Identifiable)chatMessage.getReceiver()));
                json.put("state", (Object)StateFactory.makeString(chatMessage.getState()));
                json.put("contentType", (Object)Content.getDataType((Content)chatMessage.getContent()));
                json.put("content", (Object)Content.makeString((Content)chatMessage.getContent()));
                return new BeanMessage.DBMessageData(chatMessage.getUuid(), json.toString());
            }

            @Override
            public Message decode(BeanMessage.DBMessageData data) throws JSONException {
                JSONObject json = new JSONObject(data.content);
                Message message = new Message();
                message.setUuid(json.getString("uuid"));
                message.setTimestamp(json.getLong("ts"));
                message.setSender(IDFactory.makeId((String)json.getString("sender")));
                message.setReceiver(IDFactory.makeId((String)json.getString("receiver")));
                message.setState(StateFactory.makeState(json.getString("state")));
                if ("hmr_text_message".equals(this.getDataType())) {
                    message.setContent(Content.makeContent((int)0, (String)json.getString("text")));
                } else {
                    int contentType = json.getInt("contentType");
                    message.setContent(Content.makeContent((int)contentType, (String)json.getString("content")));
                }
                return message;
            }
        };
    }
}

