/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.HMRUtils;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Set;

public class ChatUtils {
    private static final String TAG = "ChatUtils";

    static Chat newChat(@NonNull Identifiable target, String extra, Long unreadNum, Message latestMsg, long timestamp, int priority, @NonNull Set<String> tags) {
        Class<Chat> clazz = Chat.class;
        try {
            Constructor constructor = clazz.getDeclaredConstructor(Identifiable.class, String.class, Long.class, Message.class, Long.TYPE, Integer.TYPE, Set.class);
            constructor.setAccessible(true);
            return (Chat)constructor.newInstance(target, extra, unreadNum, latestMsg, timestamp, priority, tags);
        }
        catch (Exception e) {
            Log.e((String)TAG, (Object)Trace.method((String)"newChat").info("target", (Object)IDFactory.makeString((Identifiable)target)).info("error", (Object)e.getMessage()));
            return null;
        }
    }

    static String getMsgId(long timestamp, String uuid) {
        String ts = String.format(Locale.US, "%014d", timestamp).substring(0, 14);
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            return ts + "000000";
        }
        long hashed = HMRUtils.djbHash((String)uuid) % 999999L;
        return ts + String.format(Locale.US, "%06d", hashed).substring(0, 6);
    }

    public static boolean empty(String s) {
        return s == null || s.length() == 0;
    }
}

