/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.ActAddOrUpdateMessage;
import com.hummer.im._internals.ActFetchMessages;
import com.hummer.im._internals.ActFetchMessagesByUuids;
import com.hummer.im._internals.ActFixConversationsIfNeeded;
import com.hummer.im._internals.ActGetPendingChatMessages;
import com.hummer.im._internals.ActRemoveMessages;
import com.hummer.im._internals.ActResetChatUnreadNum;
import com.hummer.im._internals.ActUpdateChatLatestMsg;
import com.hummer.im._internals.ActUpdateChatPriority;
import com.hummer.im._internals.ActUpdateChatTag;
import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.ChatFlag;
import com.hummer.im._internals.ChatUtils;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.DispatchQueue;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRCompletionArg;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.Objects;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.db.DBActions;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Init;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.chat.store.MessageStoreStrategy;
import com.hummer.im.model.chat.store.RemovingClauses;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.IDType;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.ChatService;
import com.hummer.im.service.ChatStoreService;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ChatStoreServiceImpl
implements ChatStoreService,
ServiceProvider.Service {
    private static final String TAG = "ChatStoreService";
    private final ChatService.MessageServiceListener MESSAGE_SERVICE_LISTENER = new ChatService.MessageServiceListener(){

        public void onMessageReceived(final @NonNull Message message) {
            HMRContext.work.async(new Runnable(){

                @Override
                public void run() {
                    if (ChatStoreServiceImpl.this.mustIgnoreMessage(message)) {
                        return;
                    }
                    if (ChatStoreServiceImpl.this.shouldIgnoreMessage(message)) {
                        return;
                    }
                    if (message.getStoreStrategy() != null && !message.getStoreStrategy().isLocalHistoryMessage()) {
                        return;
                    }
                    ChatFlag chatFlag = ChatStoreServiceImpl.this.setupConversationIfNeeded(message, true);
                    if (chatFlag == null) {
                        Log.w((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"onMessageReceived").msg((Object)"chat is null"));
                        return;
                    }
                    ChatStoreServiceImpl.this.doAddOrUpdateMessage(chatFlag.getChat(), chatFlag.isAdd(), message, null);
                }
            });
        }

        public void onMessageStateUpdated(final @NonNull Message message) {
            HMRContext.work.async(new Runnable(){

                @Override
                public void run() {
                    if (ChatStoreServiceImpl.this.mustIgnoreMessage(message)) {
                        return;
                    }
                    if (ChatStoreServiceImpl.this.shouldIgnoreMessage(message)) {
                        return;
                    }
                    if (message.getStoreStrategy() != null && !message.getStoreStrategy().isLocalHistoryMessage()) {
                        return;
                    }
                    if (message.getState() instanceof Init) {
                        ChatFlag chatFlag = ChatStoreServiceImpl.this.setupConversationIfNeeded(message, false);
                        if (chatFlag == null) {
                            Log.w((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"onMessageStateUpdated").msg((Object)"state: [Init], chat is null"));
                            return;
                        }
                        ChatStoreServiceImpl.this.doAddOrUpdateMessage(chatFlag.getChat(), chatFlag.isAdd(), message, null);
                        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().create((Object)BeanMessage.fromMessage(message, System.currentTimeMillis()), BeanMessage.pendingConfig()));
                    } else {
                        Identifiable target;
                        if (message.getState() instanceof Archived || message.getState() instanceof Failed) {
                            ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().deleteById(BeanMessage.pendingConfig(), (Object)message.getUuid()));
                        }
                        if ((target = message.getTarget()) == null) {
                            return;
                        }
                        Chat chat = ChatStoreServiceImpl.this.getChat(target);
                        if (chat == null) {
                            return;
                        }
                        ChatStoreServiceImpl.this.addOrUpdateMessage(chat, message, null);
                    }
                }
            });
        }

        public void onContentProgressUpdated(@NonNull Message message) {
        }
    };
    private final List<Chat> chats = new ArrayList<Chat>();
    private final Set<ChatStoreService.ChatListener> chatListeners = new HashSet<ChatStoreService.ChatListener>();
    private final Map<Identifiable, Set<ChatStoreService.MessageListener>> msgListeners = new HashMap<Identifiable, Set<ChatStoreService.MessageListener>>();
    private final Set<ChatStoreService.MessageListener> commonMsgListeners = new HashSet<ChatStoreService.MessageListener>();
    private ChatStoreService.Filter filter = new ChatStoreService.Filter(){

        @Override
        public boolean shouldAcceptMessage(Message message) {
            IDType idType = IDFactory.makeType((Identifiable)message.getTarget());
            return IDType.USER.equals((Object)idType) || IDType.CHANNEL_ID.equals((Object)idType);
        }
    };
    private static final int SET_TAGS = 1;
    private static final int ADD_TAGS = 2;
    private static final int REMOVE_TAGS = 3;

    public int serviceSort() {
        return 2;
    }

    public void initService() {
    }

    public void openService(@NonNull HMRCompletion completion) {
        DBActions loadConversations = new DBActions().createTableIfNeeded(BeanConversation.class).queryAll(BeanConversation.class, (DBActions.QueryAcceptor)new DBActions.QueryAcceptor<BeanConversation>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onQueryResults(List<BeanConversation> indexes) {
                List list = ChatStoreServiceImpl.this.chats;
                synchronized (list) {
                    for (BeanConversation index : indexes) {
                        Chat c = BeanConversation.toConversation(index);
                        if (c == null) continue;
                        ChatStoreServiceImpl.this.chats.add(c);
                    }
                }
            }
        });
        DBActions handlePendingMessages = new DBActions().createTableIfNeeded(BeanMessage.pendingConfig()).custom((DBService.Action)new ActGetPendingChatMessages(new ActGetPendingChatMessages.Acceptor(){

            @Override
            public void onAcquired(List<Message> messages) {
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)"ActGetPendingChatMessages");
                Error recovered = new Error(ErrorEnum.UNKNOWN_ERROR.getCode(), "\u4ece\u5f02\u5e38\u4e2d\u6062\u590d");
                for (Message message : messages) {
                    message.setState((Message.State)new Failed(recovered));
                    Identifiable target = message.getTarget();
                    if (target == null) {
                        return;
                    }
                    Chat chat = ChatStoreServiceImpl.this.getChat(target);
                    if (chat == null) continue;
                    ChatStoreServiceImpl.this.addOrUpdateMessage(chat, message, null);
                }
            }
        })).deleteAll(BeanMessage.pendingConfig());
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActFixConversationsIfNeeded()).custom((DBService.Action)loadConversations).custom((DBService.Action)handlePendingMessages).run("Hummer.Chat.AddListener", new Runnable(){

            @Override
            public void run() {
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)"AddListener");
                ((ChatService)HMR.getService(ChatService.class)).addMessageServiceListener(ChatStoreServiceImpl.this.MESSAGE_SERVICE_LISTENER);
            }
        }), completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeService() {
        ((ChatService)HMR.getService(ChatService.class)).removeMessageServiceListener(this.MESSAGE_SERVICE_LISTENER);
        List<Chat> list = this.chats;
        synchronized (list) {
            this.chats.clear();
        }
    }

    @Override
    public void createChat(@NonNull Identifiable target, @NonNull HMR.CompletionArg<Chat> completion) {
        final HMRCompletionArg<Chat> c = this.createHMRCompletionArg(completion, "HMRCreateChat");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure(c, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        Chat chat = this.getChat(target);
        if (chat == null) {
            chat = ChatUtils.newChat(target, null, 0L, null, System.currentTimeMillis(), 0, new LinkedHashSet<String>());
            if (chat == null) {
                CompletionUtils.dispatchFailure(c, (Error)new Error(-1, "new chat error"));
                return;
            }
            final Chat finalChat = chat;
            this.addChat(chat, new HMR.Completion(){

                public void onSuccess() {
                    CompletionUtils.dispatchSuccess((HMRCompletionArg)c, (Object)finalChat);
                }

                public void onFailed(Error error) {
                    CompletionUtils.dispatchFailure((HMRCompletionArg)c, (Error)error);
                }
            });
        } else {
            CompletionUtils.dispatchFailure(c, (Error)new Error(1002, "\u4f1a\u8bdd\u5df2\u5b58\u5728"));
        }
    }

    @Override
    public void makeChat(@NonNull Identifiable target, @NonNull HMR.CompletionArg<Chat> completion) {
        HMRCompletionArg<Chat> rCompletion = this.createHMRCompletionArg(completion, "HMRMakeChat");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (target == null || !target.valid()) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Target"));
            return;
        }
        Chat chat = ChatUtils.newChat(target, null, 0L, null, System.currentTimeMillis(), 0, new LinkedHashSet<String>());
        if (chat == null) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(-1, "new chat error"));
            return;
        }
        CompletionUtils.dispatchSuccess(rCompletion, (Object)chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Chat getChat(@NonNull Identifiable target) {
        Log.i((String)TAG, (Object)Trace.method((String)"getChat").info("target", (Object)target));
        HMRContext.reportReturnCode((String)"HMRGetChat");
        if (HMR.getMe() == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"getChat").msg((Object)"User not login"));
            return null;
        }
        if (target == null) {
            return null;
        }
        List<Chat> list = this.chats;
        synchronized (list) {
            for (Chat chat : this.chats) {
                if (!Objects.equals((Object)target, (Object)chat.getTarget())) continue;
                return chat;
            }
        }
        return null;
    }

    @Override
    @NonNull
    public List<Chat> getChats() {
        HMRContext.reportReturnCode((String)"HMRFetchChats");
        if (HMR.getMe() == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"getChats").msg((Object)"User Not Login"));
            return new ArrayList<Chat>();
        }
        this.sort();
        return new ArrayList<Chat>(this.chats);
    }

    @Override
    public List<Chat> getChatsByTag(@NonNull String tag) {
        Log.i((String)TAG, (Object)Trace.method((String)"getChatsByTag").info("tag", (Object)tag));
        HMRContext.reportReturnCode((String)"HMRFetchChatsByTags");
        ArrayList<Chat> chatTagList = new ArrayList<Chat>();
        if (HMR.getMe() == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"getChatsByTag").msg((Object)"User Not Login"));
            return chatTagList;
        }
        List<Chat> chatList = this.getChats();
        for (Chat chat : chatList) {
            if (!chat.getTags().contains(tag)) continue;
            chatTagList.add(chat);
        }
        return chatTagList;
    }

    @Override
    public void addChat(final @NonNull Chat chat, @Nullable HMR.Completion completion) {
        HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRAddChat");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Chat Can Not Null"));
            return;
        }
        if (chat.getExtra() != null && chat.getExtra().getBytes(Charset.forName("UTF-8")).length > 8192) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Chat Extra Size Limit"));
            return;
        }
        final Identifiable target = chat.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "Chat Already Existed"), new DBActions.Guarder(){

            public boolean shouldBreak() {
                return ChatStoreServiceImpl.this.getChat(target) != null;
            }
        }).createTableIfNeeded(BeanChatMessage.chatMessageTableConfig(target)).create((Object)BeanConversation.fromConversation(chat), null).run("Hummer.AddConversation", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = ChatStoreServiceImpl.this.chats;
                synchronized (list) {
                    ChatStoreServiceImpl.this.chats.add(chat);
                }
                ChatStoreServiceImpl.this.notifyAfterAddingChats(chat);
            }
        }), rCompletion);
    }

    @Override
    public void removeChat(final @NonNull Chat chat, @Nullable HMR.Completion completion) {
        HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRRemoveChat");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        final Identifiable target = chat.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + target), new DBActions.Guarder(){

            public boolean shouldBreak() {
                return ChatStoreServiceImpl.this.getChat(target) == null;
            }
        }).delete((Object)BeanConversation.fromConversation(chat), null).custom((DBService.Action)new ActRemoveMessages(chat, null)).dropTableIfExist(BeanMessage.conversationConfig(target)).run("Hummer.DetachConversation", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = ChatStoreServiceImpl.this.chats;
                synchronized (list) {
                    ChatStoreServiceImpl.this.chats.remove(chat);
                }
                ChatStoreServiceImpl.this.notifyAfterRemovingChats(chat);
            }
        }), rCompletion);
    }

    @Override
    public void updateChat(final @NonNull Chat chat, @NonNull HMR.Completion completion) {
        HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRUpdateChat");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        if (chat.getExtra() != null && chat.getExtra().getBytes(Charset.forName("UTF-8")).length > 8192) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Chat Extra Size Limit"));
            return;
        }
        final Identifiable target = chat.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u4e0d\u5b58\u5728"), new DBActions.Guarder(){

            public boolean shouldBreak() {
                return ChatStoreServiceImpl.this.getChat(target) == null;
            }
        }).update((Object)BeanConversation.fromConversation(chat), null).run("Hummer.NotifyUpdateConversation", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.notifyUpdateChat(chat);
            }
        }), rCompletion);
    }

    @Override
    public void resetUnread(final @NonNull Chat chat, @Nullable HMR.Completion completion) {
        HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRResetUnreadNumber");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        if (chat.getUnreadNum() == 0L) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Unread Number Already Reset"));
            return;
        }
        chat.setUnreadNum(0L);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActResetChatUnreadNum(chat.getTarget())).run("Hummer.resetUnread", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.notifyUpdateChat(chat);
            }
        }), rCompletion);
    }

    @Override
    public void addOrUpdateMessage(@NonNull Chat chat, @NonNull Message message, @Nullable HMR.Completion completion) {
        this.doAddOrUpdateMessage(chat, false, message, completion);
    }

    private void doAddOrUpdateMessage(final @NonNull Chat chat, final boolean isAdd, final @NonNull Message message, @Nullable HMR.Completion completion) {
        HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRAddOrUpdateMessage");
        Error error = this.validAddOrUpdateMessage(chat, message);
        if (error != null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)error);
            return;
        }
        MessageStoreStrategy storeStrategy = message.getStoreStrategy();
        if (storeStrategy == null) {
            storeStrategy = new MessageStoreStrategy();
        }
        if (!storeStrategy.isLocalHistoryMessage()) {
            CompletionUtils.dispatchSuccess((HMRCompletion)rCompletion);
            return;
        }
        final MessageStoreStrategy finalStoreStrategy = storeStrategy;
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new ActAddOrUpdateMessage(chat, message, new ActAddOrUpdateMessage.Callback(){

            @Override
            public void afterSaved(boolean isAdding) {
                if (isAdding) {
                    boolean updateChatFlag = false;
                    if (chat.getLatestMsg() == null) {
                        if (!HMR.isMe((Identifiable)message.getSender()) && finalStoreStrategy.isUnreadCount() && !isAdd) {
                            chat.setUnreadNum(chat.getUnreadNum() + 1L);
                            updateChatFlag = true;
                        }
                        if (finalStoreStrategy.isLastMessage()) {
                            chat.setLatestMsg(message);
                            chat.setTimestamp(message.getTimestamp());
                            updateChatFlag = true;
                        }
                    } else if (!message.getUuid().equals(chat.getLatestMsg().getUuid())) {
                        String newMsgId;
                        String latestMsgId = ChatUtils.getMsgId(chat.getLatestMsg().getTimestamp(), chat.getLatestMsg().getUuid());
                        if (latestMsgId.compareTo(newMsgId = ChatUtils.getMsgId(message.getTimestamp(), message.getUuid())) < 0 && finalStoreStrategy.isLastMessage()) {
                            chat.setLatestMsg(message);
                            chat.setTimestamp(message.getTimestamp());
                            updateChatFlag = true;
                        }
                        if (!HMR.isMe((Identifiable)message.getSender()) && finalStoreStrategy.isUnreadCount()) {
                            chat.setUnreadNum(chat.getUnreadNum() + 1L);
                            updateChatFlag = true;
                        }
                    }
                    if (!updateChatFlag) {
                        ChatStoreServiceImpl.this.notifyAfterMessageAdding(chat, message);
                    } else {
                        ((ChatStoreService)HMR.getService(ChatStoreService.class)).updateChat(chat, new HMR.Completion(){

                            public void onSuccess() {
                                ChatStoreServiceImpl.this.notifyAfterMessageAdding(chat, message);
                            }

                            public void onFailed(Error err) {
                            }
                        });
                    }
                } else {
                    String newMsgId;
                    if (!finalStoreStrategy.isLastMessage()) {
                        ChatStoreServiceImpl.this.notifyUpdateMessage(chat, message);
                        return;
                    }
                    String latestMsgId = ChatUtils.getMsgId(chat.getLatestMsg().getTimestamp(), chat.getLatestMsg().getUuid());
                    if (latestMsgId.compareTo(newMsgId = ChatUtils.getMsgId(message.getTimestamp(), message.getUuid())) <= 0) {
                        chat.setLatestMsg(message);
                        ((ChatStoreService)HMR.getService(ChatStoreService.class)).updateChat(chat, new HMR.Completion(){

                            public void onSuccess() {
                                ChatStoreServiceImpl.this.notifyUpdateMessage(chat, message);
                            }

                            public void onFailed(Error err) {
                            }
                        });
                    } else {
                        ChatStoreServiceImpl.this.notifyUpdateMessage(chat, message);
                    }
                }
            }
        }), rCompletion);
    }

    private Error validAddOrUpdateMessage(Chat chat, Message message) {
        if (HMR.getMe() == null) {
            return new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login");
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            return new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat);
        }
        if (message == null) {
            return new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Message Can Not Be Null");
        }
        if (message.getAppExtra() != null && message.getAppExtra().getBytes(Charset.forName("UTF-8")).length > 8192) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Message Extra Size Limit");
        }
        if (message.getKvExtra() != null) {
            if (message.getKvExtra().size() > 32) {
                return new Error(ErrorEnum.INVALID_PARAMETER, "Message KvExtra Count Limit");
            }
            for (Map.Entry entry : message.getKvExtra().entrySet()) {
                if (entry.getKey() == null || "".equals(((String)entry.getKey()).trim())) {
                    return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
                }
                if (((String)entry.getKey()).getBytes(Charset.forName("UTF-8")).length > 32) {
                    return new Error(ErrorEnum.INVALID_PARAMETER, "Message KvExtra Key Size Limit");
                }
                if (((String)entry.getValue()).getBytes(Charset.forName("UTF-8")).length <= 8192) continue;
                return new Error(ErrorEnum.INVALID_PARAMETER, "Message KvExtra Value Size Limit");
            }
        }
        return null;
    }

    @Override
    public void fetchMessages(@NonNull Chat chat, @NonNull FetchingClauses clauses, @Nullable HMR.CompletionArg<List<Message>> completion) {
        final HMRCompletionArg<List<Message>> rCompletion = this.createHMRCompletionArg(completion, "HMRFetchMessageByClause");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        final ActFetchMessages fetch = new ActFetchMessages(chat, clauses);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)fetch, new HMRCompletion().onSuccess(new OnSuccess(){

            public void onSuccess() {
                CompletionUtils.dispatchSuccess((HMRCompletionArg)rCompletion, fetch.results);
            }
        }).onFailure(new OnFailure(){

            public void onFailure(Error error) {
                CompletionUtils.dispatchFailure((HMRCompletionArg)rCompletion, (Error)error);
            }
        }));
    }

    @Override
    public void fetchMessagesByUuids(@NonNull Chat chat, @NonNull Set<String> uuids, @NonNull HMR.CompletionArg<List<Message>> completion) {
        final HMRCompletionArg<List<Message>> rCompletion = this.createHMRCompletionArg(completion, "HMRFetchMessageByUuids");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        if (uuids == null || uuids.size() == 0) {
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Invaild Uuids: " + uuids));
            return;
        }
        for (String uuid : uuids) {
            if (uuid != null && !"".equals(uuid.trim())) continue;
            CompletionUtils.dispatchFailure(rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Invaild Uuids: " + uuids));
            return;
        }
        final ActFetchMessagesByUuids fetch = new ActFetchMessagesByUuids(chat, uuids);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)fetch, new HMRCompletion().onSuccess(new OnSuccess(){

            public void onSuccess() {
                CompletionUtils.dispatchSuccess((HMRCompletionArg)rCompletion, fetch.messages);
            }
        }).onFailure(new OnFailure(){

            public void onFailure(Error error) {
                CompletionUtils.dispatchFailure((HMRCompletionArg)rCompletion, (Error)error);
            }
        }));
    }

    @Override
    public void removeMessages(final @NonNull Chat chat, final @NonNull RemovingClauses clauses, @Nullable HMR.Completion completion) {
        final HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRRemoveMessageByClause");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null || this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        if (clauses.uuids != null && clauses.uuids.size() > 0) {
            final ActFetchMessagesByUuids fetch = new ActFetchMessagesByUuids(chat, clauses.uuids);
            ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)fetch, new HMRCompletion().onSuccess(new OnSuccess(){

                public void onSuccess() {
                    if (fetch.messages == null || fetch.messages.size() == 0) {
                        CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Invalid Uuids: " + clauses.uuids));
                        return;
                    }
                    ChatStoreServiceImpl.this.doRemoveMessage(fetch.messages, chat, clauses, rCompletion);
                }
            }).onFailure(new OnFailure(){

                public void onFailure(Error error) {
                    CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.DB_ERROR, "Fetch Message Error: " + error));
                }
            }));
        } else {
            this.doRemoveMessage(new ArrayList<Message>(), chat, clauses, rCompletion);
        }
    }

    private void doRemoveMessage(final List<Message> messages, final Chat chat, RemovingClauses clauses, HMRCompletion rCompletion) {
        if (clauses.messages != null && clauses.messages.size() > 0) {
            messages.addAll(clauses.messages);
        }
        if (messages.size() > 0) {
            this.notifyBeforeMessagesRemoving(chat, messages);
        }
        final Message latestMessage = chat.getLatestMsg();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActRemoveMessages(chat, new HashSet<Message>(messages))).custom((DBService.Action)new ActUpdateChatLatestMsg(chat)).run("Hummer.NotifyAfterRemovingMessages", new Runnable(){

            @Override
            public void run() {
                if (messages == null || messages.size() == 0) {
                    ChatStoreServiceImpl.this.notifyAfterMessagesClear(chat);
                    if (latestMessage != null) {
                        ChatStoreServiceImpl.this.notifyUpdateChat(chat);
                    }
                } else if (latestMessage != null && messages.contains(latestMessage)) {
                    ChatStoreServiceImpl.this.notifyUpdateChat(chat);
                }
            }
        }), rCompletion);
    }

    @Override
    public void setPriority(final @NonNull Chat chat, int priority, @Nullable HMR.Completion completion) {
        HMRCompletion rCompletion = this.createHMRCompletion(completion, "HMRSetChatPriority");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Is Illegal: " + chat));
            return;
        }
        if (this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        if (chat.getPriority() == priority) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Operation Duplicated"));
            return;
        }
        if (priority < 0 || priority >= 100000) {
            CompletionUtils.dispatchFailure((HMRCompletion)rCompletion, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Priority Is Invalid"));
            return;
        }
        chat.setPriority(priority);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActUpdateChatPriority(chat.getTarget(), chat.getPriority())).run("ChatStoreService::setPriority", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.notifyUpdateChat(chat);
            }
        }), rCompletion);
    }

    @Override
    public void setTags(@NonNull Chat chat, @NonNull Set<String> tags, @Nullable HMR.Completion completion) {
        Error error;
        HMRCompletion c = this.createHMRCompletion(completion, "HMRSetChatTags");
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login"));
            return;
        }
        if (chat == null || chat.getTarget() == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Is Illegal: " + chat));
            return;
        }
        if (tags != null && tags.size() > 0 && (error = this.validSetTags(tags)) != null) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)error);
            return;
        }
        if (this.getChat(chat.getTarget()) == null) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat));
            return;
        }
        chat.setTags(tags);
        this.handleTags(chat, c);
    }

    @Override
    public void addTags(@NonNull Chat chat, @NonNull Set<String> tags, @Nullable HMR.Completion completion) {
        HMRCompletion c = this.createHMRCompletion(completion, "HMRAddChatTags");
        Error error = this.validTags(chat, tags);
        if (error != null) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)error);
            return;
        }
        if (chat.getTags().containsAll(tags)) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Tags Already Existed"));
            return;
        }
        chat.getTags().addAll(tags);
        this.handleTags(chat, c);
    }

    @Override
    public void removeTags(@NonNull Chat chat, @NonNull Set<String> tags, @Nullable HMR.Completion completion) {
        HMRCompletion c = this.createHMRCompletion(completion, "HMRRemoveChatTags");
        Error error = this.validTags(chat, tags);
        if (error != null) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)error);
            return;
        }
        if (!chat.getTags().containsAll(tags)) {
            CompletionUtils.dispatchFailure((HMRCompletion)c, (Error)new Error(ErrorEnum.INVALID_PARAMETER, "Tags Not Exist"));
            return;
        }
        chat.getTags().removeAll(tags);
        this.handleTags(chat, c);
    }

    private void handleTags(final @NonNull Chat chat, @Nullable HMRCompletion completion) {
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActUpdateChatTag(chat.getTarget(), chat.getTags())).run(new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.notifyUpdateChat(chat);
            }
        }), completion);
    }

    private Error validTags(Chat chat, Set<String> tags) {
        if (HMR.getMe() == null) {
            return new Error(ErrorEnum.BAD_USER_ERROR, "User Not Login");
        }
        if (chat == null || chat.getTarget() == null) {
            return new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Is Illegal: " + chat);
        }
        if (tags == null || tags.size() == 0) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Tags Cannot Be Null");
        }
        Error error = this.validTags(tags);
        if (error != null) {
            return error;
        }
        if (this.getChat(chat.getTarget()) == null) {
            return new Error(ErrorEnum.SDK_INVALID_PARAMETERS, "Chat Can Not Be Found: " + chat);
        }
        return null;
    }

    private Error validTags(Set<String> tags) {
        if (tags.size() > 32) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Tags Count Limit");
        }
        for (String tag : tags) {
            if (tag == null || "".equals(tag)) {
                return new Error(ErrorEnum.INVALID_PARAMETER, "Tags Cannot Be Null");
            }
            if (tag.getBytes(Charset.forName("UTF-8")).length <= 1024) continue;
            return new Error(ErrorEnum.INVALID_PARAMETER, "Tag Size Limit");
        }
        return null;
    }

    private Error validSetTags(Set<String> tags) {
        if (tags.size() > 32) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Tags Count Limit");
        }
        Iterator<String> iterator = tags.iterator();
        while (iterator.hasNext()) {
            String tag = iterator.next();
            if (tag == null || "".equals(tag)) {
                iterator.remove();
                continue;
            }
            if (tag.getBytes(Charset.forName("UTF-8")).length <= 1024) continue;
            return new Error(ErrorEnum.INVALID_PARAMETER, "Tag Size Limit");
        }
        return null;
    }

    @Override
    public void addChatListener(final @NonNull ChatStoreService.ChatListener listener) {
        HMRContext.reportReturnCode((String)"HMRAddChatObserver");
        HMRContext.work.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = ChatStoreServiceImpl.this.chatListeners;
                synchronized (set) {
                    ChatStoreServiceImpl.this.chatListeners.add(listener);
                }
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"addChatListener").info("listener", (Object)listener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
            }
        });
    }

    @Override
    public void removeChatListener(final @NonNull ChatStoreService.ChatListener listener) {
        HMRContext.reportReturnCode((String)"HMRRemoveChatObserver");
        HMRContext.work.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = ChatStoreServiceImpl.this.chatListeners;
                synchronized (set) {
                    ChatStoreServiceImpl.this.chatListeners.remove(listener);
                }
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"removeChatListener").info("listener", (Object)listener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
            }
        });
    }

    @Override
    public void addMessageListener(final @Nullable Chat chat, final @NonNull ChatStoreService.MessageListener listener) {
        HMRContext.reportReturnCode((String)"HMRAddChatMessageObserver");
        HMRContext.work.async(new Runnable(){

            @Override
            public void run() {
                if (chat == null) {
                    ChatStoreServiceImpl.this.commonMsgListeners.add(listener);
                    return;
                }
                HashSet<ChatStoreService.MessageListener> listeners = (HashSet<ChatStoreService.MessageListener>)ChatStoreServiceImpl.this.msgListeners.get(chat.getTarget());
                if (listeners == null) {
                    listeners = new HashSet<ChatStoreService.MessageListener>();
                    ChatStoreServiceImpl.this.msgListeners.put(chat.getTarget(), listeners);
                }
                listeners.add(listener);
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"addMessageListener").info("chat", (Object)chat).info("listener", (Object)listener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
            }
        });
    }

    @Override
    public void removeMessageListener(final @Nullable Chat chat, final @NonNull ChatStoreService.MessageListener listener) {
        HMRContext.reportReturnCode((String)"HMRRemoveChatMessageObserver");
        HMRContext.work.async(new Runnable(){

            @Override
            public void run() {
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"removeMessageListener").info("chat", (Object)chat).info("listener", (Object)listener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
                if (chat == null) {
                    ChatStoreServiceImpl.this.commonMsgListeners.remove(listener);
                    return;
                }
                Set listeners = (Set)ChatStoreServiceImpl.this.msgListeners.get(chat.getTarget());
                if (listeners == null) {
                    return;
                }
                listeners.remove(listener);
            }
        });
    }

    private void notifyAfterAddingChats(final @NonNull Chat chat) {
        DispatchQueue.main.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = ChatStoreServiceImpl.this.chatListeners;
                synchronized (set) {
                    for (ChatStoreService.ChatListener l : ChatStoreServiceImpl.this.chatListeners) {
                        l.afterCreatingChat(chat);
                        l.afterAddChat(chat);
                        l.afterUpdateChats(ChatStoreServiceImpl.this.getChats());
                    }
                }
            }
        });
    }

    private void notifyAfterRemovingChats(final @NonNull Chat chat) {
        DispatchQueue.main.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = ChatStoreServiceImpl.this.chatListeners;
                synchronized (set) {
                    for (ChatStoreService.ChatListener l : ChatStoreServiceImpl.this.chatListeners) {
                        l.beforeRemovingChat(chat);
                        l.afterUpdateChats(ChatStoreServiceImpl.this.getChats());
                    }
                }
            }
        });
    }

    private void notifyUpdateChat(final @NonNull Chat chat) {
        if (this.chatListeners.size() == 0) {
            return;
        }
        DispatchQueue.main.sync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"notifyUpdateChat").info("target", (Object)chat.getTarget().getId()));
                Set set = ChatStoreServiceImpl.this.chatListeners;
                synchronized (set) {
                    for (ChatStoreService.ChatListener l : ChatStoreServiceImpl.this.chatListeners) {
                        l.afterUpdateChat(chat);
                        l.afterUpdateChats(ChatStoreServiceImpl.this.getChats());
                    }
                }
            }
        });
    }

    private void iterateMessageListeners(final Chat chat, final MessageListenersVisitor visitor) {
        DispatchQueue.main.sync(new Runnable(){

            @Override
            public void run() {
                HashSet listeners = new HashSet(ChatStoreServiceImpl.this.commonMsgListeners);
                Set specificListeners = (Set)ChatStoreServiceImpl.this.msgListeners.get(chat.getTarget());
                if (specificListeners != null) {
                    listeners.addAll(specificListeners);
                }
                for (ChatStoreService.MessageListener l : listeners) {
                    visitor.visit(l);
                }
            }
        });
    }

    private void notifyAfterMessageAdding(final @NonNull Chat chat, final @NonNull Message message) {
        Log.i((String)TAG, (Object)Trace.method((String)"notifyAfterMessageAdding").info("target", (Object)chat.getTarget()).info("uuid", (Object)message.getUuid()));
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener listener) {
                listener.afterAddingMessage(chat, message);
            }

            @Override
            public String visitorName() {
                return "notifyAfterMessageAdding";
            }
        });
    }

    private void notifyUpdateMessage(final @NonNull Chat chat, final Message message) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener listener) {
                listener.afterUpdateMessage(chat, message);
            }

            @Override
            public String visitorName() {
                return "notifyUpdateMessage";
            }
        });
    }

    private void notifyBeforeMessagesRemoving(final @NonNull Chat chat, final List<Message> messages) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener listener) {
                listener.beforeRemovingMessages(chat, messages);
            }

            @Override
            public String visitorName() {
                return "notifyBeforeMessagesRemoving";
            }
        });
    }

    private void notifyAfterMessagesClear(final @NonNull Chat chat) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener listener) {
                listener.afterClearMessages(chat);
            }

            @Override
            public String visitorName() {
                return "notifyAfterMessagesClear";
            }
        });
    }

    @Override
    public void setChatFilter(ChatStoreService.Filter filter) {
        HMRContext.reportReturnCode((String)"HMRSetChatFilter");
        this.filter = filter;
    }

    private boolean shouldIgnoreMessage(@NonNull Message message) {
        return !this.filter.shouldAcceptMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatFlag setupConversationIfNeeded(Message message, boolean isReceive) {
        Chat finalChat;
        Identifiable target;
        if (message.getReceiver() instanceof AppSession) {
            Log.i((String)TAG, (Object)Trace.method((String)"parseBroadCastAppSessionChatMessage").msg((Object)"setupConversationIfNeeded").info("receiver type", (Object)((AppSession)message.getReceiver()).getType()).info("id", (Object)message.getReceiver().getId()));
        }
        if ((target = message.getTarget()) == null) {
            return null;
        }
        Chat chat = this.getChat(target);
        if (chat != null) {
            return new ChatFlag(chat, false);
        }
        MessageStoreStrategy storeStrategy = message.getStoreStrategy();
        if (storeStrategy == null) {
            storeStrategy = new MessageStoreStrategy();
        }
        long unreadCount = 0L;
        if (isReceive && storeStrategy.isUnreadCount()) {
            unreadCount = 1L;
        }
        Message current = null;
        long timestamp = System.currentTimeMillis();
        if (storeStrategy.isLastMessage()) {
            current = message;
            timestamp = message.getTimestamp();
        }
        if ((finalChat = ChatUtils.newChat(target, null, unreadCount, current, timestamp, 0, new LinkedHashSet<String>())) == null) {
            return null;
        }
        List<Chat> list = this.chats;
        synchronized (list) {
            this.chats.add(finalChat);
        }
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().createTableIfNeeded(BeanChatMessage.chatMessageTableConfig(target)).createIfNotExists((Object)BeanConversation.fromConversation(finalChat), null).run("Hummer.Run.SetupConversationIfNeeded", new Runnable(){

            @Override
            public void run() {
                Log.w((String)ChatStoreServiceImpl.TAG, (Object)Trace.method((String)"setupConversationIfNeeded").msg((Object)"Chat Created!"));
                ChatStoreServiceImpl.this.notifyAfterAddingChats(finalChat);
            }
        }));
        return new ChatFlag(finalChat, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort() {
        if (this.chats.size() < 2) {
            return;
        }
        List<Chat> list = this.chats;
        synchronized (list) {
            Collections.sort(this.chats, new Comparator<Chat>(){

                @Override
                public int compare(Chat c1, Chat c2) {
                    int y;
                    if (c1.getPriority() == c2.getPriority()) {
                        long y2;
                        long x = c2.getTimestamp();
                        return x < (y2 = c1.getTimestamp()) ? -1 : (x == y2 ? 0 : 1);
                    }
                    int x = c2.getPriority();
                    return x < (y = c1.getPriority()) ? -1 : (x == y ? 0 : 1);
                }
            });
        }
    }

    private boolean mustIgnoreMessage(Message message) {
        return IDType.CHAT_ROOM.equals((Object)IDFactory.makeType((Identifiable)message.getTarget()));
    }

    private <T> HMRCompletionArg<T> createHMRCompletionArg(final HMR.CompletionArg<T> completion, final String functionName) {
        final long currentTs = System.currentTimeMillis();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        return new HMRCompletionArg(requestId, new HMR.CompletionArg<T>(){

            public void onSuccess(T obj) {
                if (completion != null) {
                    completion.onSuccess(obj);
                }
                HMRContext.reportReturnCode((String)functionName, (long)currentTs);
            }

            public void onFailed(Error err) {
                if (completion != null) {
                    completion.onFailed(err);
                }
                HMRContext.reportReturnCode((String)functionName, (long)currentTs, (Error)err);
            }
        });
    }

    private HMRCompletion createHMRCompletion(final HMR.Completion completion, final String functionName) {
        final long currentTimestamp = System.currentTimeMillis();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        return new HMRCompletion(requestId, new HMR.Completion(){

            public void onSuccess() {
                if (completion != null) {
                    completion.onSuccess();
                }
                HMRContext.reportReturnCode((String)functionName, (long)currentTimestamp);
            }

            public void onFailed(Error err) {
                if (completion != null) {
                    completion.onFailed(err);
                }
                HMRContext.reportReturnCode((String)functionName, (long)currentTimestamp, (Error)err);
            }
        });
    }

    static interface MessageListenersVisitor {
        public void visit(ChatStoreService.MessageListener var1);

        public String visitorName();
    }
}

