/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class BeanMessage
implements Serializable {
    static final String FieldKey = "key";
    static final String FieldTimestamp = "ts";
    static final String FieldType = "type";
    static final String FieldContent = "content";
    static final String FieldDelFlag = "deleted";
    @DatabaseField(columnName="key", dataType=DataType.STRING, id=true)
    String key;
    @DatabaseField(columnName="ts", dataType=DataType.LONG, canBeNull=false)
    long ts;
    @DatabaseField(columnName="type", dataType=DataType.STRING, canBeNull=false)
    String type;
    @DatabaseField(columnName="content", dataType=DataType.STRING, canBeNull=false)
    String content;
    @DatabaseField(columnName="deleted", dataType=DataType.BOOLEAN, canBeNull=false)
    boolean deleted;
    public static final CodecManager<String, DBMessageData, Message> codecs = new CodecManager();

    public BeanMessage() {
    }

    private BeanMessage(String key, String type, String content, Long ts) {
        this.content = content;
        this.key = key;
        this.type = type;
        this.deleted = false;
        if (ts != null) {
            this.ts = ts;
        }
    }

    public String toString() {
        return "BeanMessage{" + this.key + ", " + this.type + ", " + this.content + "}";
    }

    static DatabaseTableConfig<BeanMessage> conversationConfig(Identifiable target) {
        DatabaseTableConfig config = new DatabaseTableConfig();
        String tableName = "conversation_" + IDFactory.makeString((Identifiable)target);
        config.setTableName(tableName);
        config.setDataClass(BeanMessage.class);
        return config;
    }

    static DatabaseTableConfig<BeanMessage> pendingConfig() {
        DatabaseTableConfig config = new DatabaseTableConfig();
        String tableName = "pending_chat_messages";
        config.setTableName(tableName);
        config.setDataClass(BeanMessage.class);
        return config;
    }

    static Message toMessage(BeanMessage dbMessage) {
        return codecs.decode(dbMessage.type, new DBMessageData(dbMessage.key, dbMessage.content));
    }

    static List<Message> toMessages(List<BeanMessage> dbMessages) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (BeanMessage dbMsg : dbMessages) {
            Message message = BeanMessage.toMessage(dbMsg);
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    static List<BeanMessage> fromMessages(List<Message> messages) {
        ArrayList<BeanMessage> dbItems = new ArrayList<BeanMessage>();
        for (Message message : messages) {
            dbItems.add(BeanMessage.fromMessage(message, System.currentTimeMillis()));
        }
        return dbItems;
    }

    static BeanMessage fromMessage(Message message, Long timestamp) {
        DBMessageData data = codecs.encode(message);
        return new BeanMessage(data.key, codecs.getDataType(message), data.content, timestamp);
    }

    public static class DBMessageData {
        public final String key;
        public final String content;

        public DBMessageData(String key, String content) {
            this.key = key;
            this.content = content;
        }

        public String toString() {
            return "DBMessageData{" + this.key + ", " + this.content + "}";
        }
    }
}

