/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im._internals.ChatUtils;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

@DatabaseTable(tableName="conversation_indexes")
public class BeanConversation
implements Serializable {
    private static final String TAG = "BeanConversation";
    static final String FieldName = "name";
    static final String FieldExtra = "extra";
    static final String FIELD_UNREAD_NUM = "unread_num";
    static final String FIELD_LATEST_MSG = "latest_msg";
    static final String FIELD_TIMESTAMP = "timestamp";
    static final String CODEC_TYPE_NAME = "chat_latest_message";
    static final String FIELD_TAGS = "tags";
    static final String FIELD_PRIORITY = "priority";
    @DatabaseField(id=true, columnName="name", unique=true)
    String name;
    @DatabaseField(columnName="extra")
    String extra;
    @DatabaseField(columnName="unread_num", dataType=DataType.LONG)
    long unreadNum;
    @DatabaseField(columnName="latest_msg", dataType=DataType.STRING, defaultValue="")
    String latestMsg;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    long timestamp;
    @DatabaseField(columnName="priority", dataType=DataType.INTEGER)
    int priority;
    @DatabaseField(columnName="tags", dataType=DataType.STRING)
    String tags;
    public static final CodecManager<String, String, Message> codecs = new CodecManager();

    public BeanConversation() {
    }

    public BeanConversation(@NonNull String name, @Nullable String extra, long unreadNum, @NonNull String latestMsg, long timestamp, int priority, @NonNull String tags) {
        this.name = name;
        this.extra = extra;
        this.unreadNum = unreadNum;
        this.latestMsg = latestMsg;
        this.timestamp = timestamp;
        this.priority = priority;
        this.tags = tags;
    }

    public String toString() {
        return "BeanConversation{" + this.name + "}";
    }

    static BeanConversation fromConversation(@NonNull Chat chat) {
        BeanConversation index = new BeanConversation();
        index.name = IDFactory.makeString((Identifiable)chat.getTarget());
        index.extra = chat.getExtra();
        index.unreadNum = chat.getUnreadNum();
        index.latestMsg = chat.getLatestMsg() != null ? codecs.encode(chat.getLatestMsg()) : "";
        index.timestamp = chat.getTimestamp();
        index.priority = chat.getPriority();
        index.tags = new JSONArray(chat.getTags()).toString();
        return index;
    }

    static Chat toConversation(@NonNull BeanConversation dbConversation) {
        JSONArray jsonArray;
        if (dbConversation.name == null) {
            Log.w((String)TAG, (Object)"chat name is null");
            return null;
        }
        Identifiable target = IDFactory.makeId((String)dbConversation.name);
        Message latestMessage = null;
        if (dbConversation.latestMsg != null && dbConversation.latestMsg.length() > 0) {
            latestMessage = codecs.decode(CODEC_TYPE_NAME, dbConversation.latestMsg);
        }
        try {
            jsonArray = new JSONArray(dbConversation.tags);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (Object)Trace.method((String)"toConversation").info("toArray error", (Object)e.getMessage()));
            jsonArray = new JSONArray();
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                tags.add(jsonArray.getString(i));
                continue;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (Object)Trace.method((String)"toConversation").info("getString error", (Object)e.getMessage()));
            }
        }
        return ChatUtils.newChat(target, dbConversation.extra, dbConversation.unreadNum, latestMessage, dbConversation.timestamp, dbConversation.priority, tags);
    }

    static List<BeanConversation> fromConversations(@NonNull List<Chat> chats) {
        ArrayList<BeanConversation> dbConversations = new ArrayList<BeanConversation>();
        for (Chat c : chats) {
            dbConversations.add(BeanConversation.fromConversation(c));
        }
        return dbConversations;
    }

    static List<Chat> toConversations(@NonNull List<BeanConversation> dbConversations) {
        ArrayList<Chat> chats = new ArrayList<Chat>();
        for (BeanConversation c : dbConversations) {
            Chat chat = BeanConversation.toConversation(c);
            if (chat == null) continue;
            chats.add(BeanConversation.toConversation(c));
        }
        return chats;
    }
}

