/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.text.TextUtils;
import com.hummer.im._internals.ChatUtils;
import com.hummer.im._internals.chatsvc.IdentifiableHelper;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.states.StateFactory;
import com.hummer.im.model.chat.store.MessageStoreStrategy;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public final class BeanChatMessage
implements Serializable {
    static final String FIELD_ID = "id";
    static final String FIELD_SENDER = "sender";
    static final String FIELD_RECEIVER = "receiver";
    static final String FIELD_TIMESTAMP = "timestamp";
    static final String FIELD_STATE = "state";
    static final String FIELD_APP_EXTRA = "app_extra";
    static final String FIELD_KV_EXTRA = "kv_extra";
    static final String FIELD_PUSH_CONTENT = "push_content";
    static final String FIELD_CONTENT_TYPE = "content_type";
    static final String FIELD_CONTENT = "content";
    static final String FIELD_NEW_CONTENT = "new_content";
    static final String FIELD_MSG_ID = "msg_id";
    static final String FIELD_DELETED = "deleted";
    static final String FIELD_IS_LAST_MESSAGE = "is_last_message";
    static final String FILED_STORE_STRATEGY = "store_strategy";
    @DatabaseField(columnName="id", dataType=DataType.STRING, id=true)
    String id;
    @DatabaseField(columnName="sender", dataType=DataType.STRING, canBeNull=false, index=true)
    String sender;
    @DatabaseField(columnName="receiver", dataType=DataType.STRING, canBeNull=false, index=true)
    String receiver;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG, canBeNull=false)
    long timestamp;
    @DatabaseField(columnName="state", dataType=DataType.STRING, canBeNull=false)
    String state;
    @DatabaseField(columnName="app_extra", dataType=DataType.STRING, canBeNull=false, defaultValue="")
    String appExtra;
    @DatabaseField(columnName="kv_extra", dataType=DataType.STRING, canBeNull=false, defaultValue="")
    String kvExtra;
    @DatabaseField(columnName="push_content", dataType=DataType.STRING, canBeNull=false, defaultValue="")
    String pushContent;
    @DatabaseField(columnName="content_type", dataType=DataType.INTEGER, canBeNull=false)
    int contentType;
    @DatabaseField(columnName="content", dataType=DataType.STRING, canBeNull=false)
    String content;
    @DatabaseField(columnName="new_content", dataType=DataType.STRING, canBeNull=false, defaultValue="")
    String newContent;
    @DatabaseField(columnName="deleted", dataType=DataType.BOOLEAN, canBeNull=false)
    boolean deleted;
    @DatabaseField(columnName="is_last_message", dataType=DataType.BOOLEAN, canBeNull=false, defaultValue="true")
    boolean isLastMessage;
    @DatabaseField(columnName="store_strategy", dataType=DataType.STRING, canBeNull=false, defaultValue="")
    String storeStrategy;
    @DatabaseField(columnName="msg_id", dataType=DataType.STRING, canBeNull=false, index=true)
    String msgId;
    private static final String TAG = "BeanChatMessage";

    public BeanChatMessage() {
    }

    private BeanChatMessage(String id, String sender, String receiver, long timestamp, String state, String appExtra, String kvExtra, String pushContent, int contentType, String content, String newContent, boolean isLastMessage, String storeStrategy, String msgId) {
        this.id = id;
        this.sender = sender;
        this.receiver = receiver;
        this.timestamp = timestamp;
        this.state = state;
        this.appExtra = appExtra;
        this.kvExtra = kvExtra;
        this.pushContent = pushContent;
        this.contentType = contentType;
        this.content = content;
        this.newContent = newContent;
        this.deleted = false;
        this.isLastMessage = isLastMessage;
        this.storeStrategy = storeStrategy;
        this.msgId = msgId;
    }

    static DatabaseTableConfig<BeanChatMessage> chatMessageTableConfig(Identifiable target) {
        return BeanChatMessage.chatMessageTableConfig(IdentifiableHelper.hash((Identifiable)target));
    }

    static DatabaseTableConfig<BeanChatMessage> chatMessageTableConfig(int suffix) {
        DatabaseTableConfig config = new DatabaseTableConfig();
        String tableName = "chat_message_" + suffix;
        config.setTableName(tableName);
        config.setDataClass(BeanChatMessage.class);
        return config;
    }

    static Message toMessage(BeanChatMessage dbMessage) {
        Message message = new Message();
        message.setUuid(dbMessage.id);
        message.setTimestamp(dbMessage.timestamp);
        message.setSender(IDFactory.makeId((String)dbMessage.sender));
        message.setReceiver(IDFactory.makeId((String)dbMessage.receiver));
        message.setState(StateFactory.makeState(dbMessage.state));
        message.setPushContent(PushContent.makeContent((String)dbMessage.pushContent));
        message.setStoreStrategy(MessageStoreStrategy.makeContent((String)dbMessage.storeStrategy));
        if (TextUtils.isEmpty((CharSequence)dbMessage.newContent)) {
            message.setContent(Content.makeStringContent((int)dbMessage.contentType, (String)dbMessage.content));
        } else {
            message.setContent(Content.makeContent((int)dbMessage.contentType, (String)dbMessage.newContent));
        }
        message.setAppExtra(dbMessage.appExtra);
        if (!TextUtils.isEmpty((CharSequence)dbMessage.kvExtra)) {
            try {
                JSONObject json = new JSONObject(dbMessage.kvExtra);
                HashMap<String, String> kvExtra = new HashMap<String, String>(json.length());
                Iterator keys = json.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    kvExtra.put(key, json.getString(key));
                }
                message.setKvExtra(kvExtra);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (Object)Trace.method((String)"toMessage").info("kvExtra", (Object)dbMessage.kvExtra).info("parse error", (Object)e.getMessage()));
            }
        } else {
            message.setKvExtra(Collections.emptyMap());
        }
        return message;
    }

    static List<Message> toMessages(List<BeanChatMessage> chatMessages) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (BeanChatMessage chatMessage : chatMessages) {
            Message message = BeanChatMessage.toMessage(chatMessage);
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    static BeanChatMessage fromMessage(Message message) {
        long timestamp = message.getTimestamp() < 1L ? System.currentTimeMillis() : message.getTimestamp();
        String kvExtra = "";
        if (message.getKvExtra() != null && message.getKvExtra().size() > 0) {
            JSONObject json = new JSONObject(message.getKvExtra());
            kvExtra = json.toString();
        }
        return new BeanChatMessage(message.getUuid(), IDFactory.makeString((Identifiable)message.getSender()), IDFactory.makeString((Identifiable)message.getReceiver()), timestamp, StateFactory.makeString(message.getState()), message.getAppExtra() == null ? "" : message.getAppExtra(), kvExtra, PushContent.makeString((PushContent)message.getPushContent()), Content.getDataType((Content)message.getContent()), "", Content.makeString((Content)message.getContent()), message.getStoreStrategy().isLastMessage(), MessageStoreStrategy.makeString((MessageStoreStrategy)message.getStoreStrategy()), ChatUtils.getMsgId(timestamp, message.getUuid()));
    }

    public String toString() {
        return "BeanChatMessage{id='" + this.id + '\'' + '}';
    }
}

