/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class ActUpdateChatTag
implements DBService.Action {
    private static final String SQL = "update conversation_indexes set %s = ? where name = ?";
    private Identifiable target;
    private Set<String> tagSet;
    private static final String TAG = "ActUpdateChatTag";

    ActUpdateChatTag(Identifiable target, Set<String> tagSet) {
        this.target = target;
        this.tagSet = tagSet;
    }

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        String tags;
        Log.i((String)TAG, (Object)Trace.method((String)"process").info("target", (Object)this.target.toString()).info("tag", this.tagSet));
        try {
            tags = new JSONArray(this.tagSet.toString()).toString();
        }
        catch (JSONException e) {
            Log.e((String)TAG, (Object)Trace.method((String)"process").msg((Object)("tag to json error : " + e.getMessage())));
            tags = "[]";
        }
        String sql = String.format(Locale.US, SQL, "tags");
        Dao dao = daoSet.create(null, BeanConversation.class);
        dao.updateRaw(sql, new String[]{tags, IDFactory.makeString((Identifiable)this.target)});
    }

    public String toString() {
        return "ActUpdateChatTag | target: " + this.target.getId() + ", tags: " + this.tagSet;
    }
}

