/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import androidx.annotation.NonNull;
import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.List;

public class ActUpdateChatLatestMsg
implements DBService.Action {
    private static final String TAG = "ActUpdateChatLatestMsg";
    private final Chat chat;

    ActUpdateChatLatestMsg(@NonNull Chat chat) {
        this.chat = chat;
    }

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        if (this.chat == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"process").msg((Object)"chat is null"));
            return;
        }
        DatabaseTableConfig<BeanChatMessage> tableConfig = BeanChatMessage.chatMessageTableConfig(this.chat.getTarget());
        String condition = String.format("(%s = '%s' or %s = '%s')", "sender", IDFactory.makeString((Identifiable)this.chat.getTarget()), "receiver", IDFactory.makeString((Identifiable)this.chat.getTarget()));
        QueryBuilder queryBuilder = daoSet.create(tableConfig, null).queryBuilder();
        queryBuilder.where().eq("deleted", (Object)false).and().eq("is_last_message", (Object)true).and().raw(condition, new ArgumentHolder[0]);
        queryBuilder.orderBy("msg_id", false);
        queryBuilder.limit(Long.valueOf(1L));
        List beanMessageList = queryBuilder.query();
        if (beanMessageList.size() > 0) {
            Message message = BeanChatMessage.toMessage((BeanChatMessage)beanMessageList.get(0));
            this.chat.setLatestMsg(message);
            this.chat.setTimestamp(message.getTimestamp());
        } else {
            this.chat.setLatestMsg(null);
        }
        Dao conversationDao = daoSet.create(null, BeanConversation.class);
        conversationDao.update((Object)BeanConversation.fromConversation(this.chat));
    }
}

