/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hummer.im._internals.BeanChatMessage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;

public class ActRemoveMessages
implements DBService.Action {
    private static final String TAG = "ActRemoveMessages";
    private final Set<Message> messages;
    private final Chat chat;

    ActRemoveMessages(@NonNull Chat chat, @NonNull Set<Message> messages) {
        this.messages = messages;
        this.chat = chat;
    }

    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i((String)TAG, (Object)Trace.method((String)"process").msg((Object)this.chat.getTarget().toString()));
        DatabaseTableConfig<BeanChatMessage> config = BeanChatMessage.chatMessageTableConfig(this.chat.getTarget());
        if (config.getTableName() == null) {
            Log.e((String)TAG, (Object)Trace.method((String)"process").info("table name exception", null));
        }
        Dao dao = daoSet.create(config, BeanChatMessage.class);
        if (this.messages == null || this.messages.size() == 0) {
            String stmt = String.format(Locale.US, "update %s set %s = 1 where %s = '%s' or %s = '%s'", config.getTableName(), "deleted", "sender", IDFactory.makeString((Identifiable)this.chat.getTarget()), "receiver", IDFactory.makeString((Identifiable)this.chat.getTarget()));
            dao.updateRaw(stmt, new String[0]);
        } else {
            StringBuilder idSb = new StringBuilder();
            int i = 0;
            for (Message message : this.messages) {
                if (i++ > 0) {
                    idSb.append(",");
                }
                idSb.append("'").append(message.getUuid()).append("'");
            }
            String ids = idSb.toString();
            if (TextUtils.isEmpty((CharSequence)ids)) {
                Log.w((String)TAG, (Object)Trace.method((String)"process").msg((Object)"ids does not set"));
                return;
            }
            String stmt = String.format(Locale.US, "UPDATE %s SET %s = 1 WHERE %s IN (%s)", config.getTableName(), "deleted", "id", ids);
            dao.updateRaw(stmt, new String[0]);
        }
    }

    public String toString() {
        return "Hummer.ActRemoveMessages | chat: " + this.chat + ", messages: " + this.messages;
    }
}

